/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.plugins.utils;

import com.jn.agileway.ssh.client.SshException;
import com.jn.langx.util.logging.Loggers;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.KeyAgreement;
import org.slf4j.Logger;

public class SecurityUtils {
    private static final Logger LOG = Loggers.getLogger(SecurityUtils.class);
    public static final String BOUNCY_CASTLE = "BC";
    public static final String SPONGY_CASTLE = "SC";
    private static String securityProvider = null;
    private static Boolean registerBouncyCastle;
    private static boolean registrationDone;

    public static boolean registerSecurityProvider(String providerClassName) {
        Provider provider = null;
        try {
            Class<?> name = Class.forName(providerClassName);
            provider = (Provider)name.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            LOG.info("Security Provider class '{}' not found", (Object)providerClassName);
        }
        catch (InstantiationException e) {
            LOG.info("Security Provider class '{}' could not be created", (Object)providerClassName);
        }
        catch (IllegalAccessException e) {
            LOG.info("Security Provider class '{}' could not be accessed", (Object)providerClassName);
        }
        catch (InvocationTargetException e) {
            LOG.info("Security Provider class '{}' could not be created", (Object)providerClassName);
        }
        catch (NoSuchMethodException e) {
            LOG.info("Security Provider class '{}' does not have a no-args constructor", (Object)providerClassName);
        }
        if (provider == null) {
            return false;
        }
        try {
            if (Security.getProvider(provider.getName()) == null) {
                Security.addProvider(provider);
            }
            if (securityProvider == null) {
                MessageDigest.getInstance("MD5", provider);
                KeyAgreement.getInstance("DH", provider);
                SecurityUtils.setSecurityProvider(provider.getName());
                return true;
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOG.info("Security Provider '{}' does not support necessary algorithm", (Object)providerClassName, (Object)e);
        }
        catch (Exception e) {
            LOG.info("Registration of Security Provider '{}' unexpectedly failed", (Object)providerClassName, (Object)e);
        }
        return false;
    }

    public static synchronized boolean isBouncyCastleRegistered() {
        Provider[] providers;
        SecurityUtils.register();
        for (Provider provider : providers = Security.getProviders()) {
            String name = provider.getName();
            if (!BOUNCY_CASTLE.equals(name) && !SPONGY_CASTLE.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static synchronized void setRegisterBouncyCastle(boolean registerBouncyCastle) {
        SecurityUtils.registerBouncyCastle = registerBouncyCastle;
        registrationDone = false;
    }

    public static synchronized void setSecurityProvider(String securityProvider) {
        SecurityUtils.securityProvider = securityProvider;
        registrationDone = false;
    }

    private static void register() {
        if (!registrationDone) {
            if (securityProvider == null && (registerBouncyCastle == null || registerBouncyCastle.booleanValue())) {
                SecurityUtils.registerSecurityProvider("org.bouncycastle.jce.provider.BouncyCastleProvider");
                if (securityProvider == null && registerBouncyCastle == null) {
                    LOG.info("BouncyCastle not registered, using the default JCE provider");
                } else if (securityProvider == null) {
                    LOG.error("Failed to register BouncyCastle as the defaut JCE provider");
                    throw new SshException("Failed to register BouncyCastle as the defaut JCE provider");
                }
            }
            registrationDone = true;
        }
    }
}

