/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.plugins.codec;

import com.jn.agileway.ssh.client.SshException;
import com.jn.agileway.ssh.client.plugins.codec.Ed25519PublicKey;
import com.jn.agileway.ssh.client.transport.hostkey.codec.AbstractPublicKeyCodec;
import com.jn.agileway.ssh.client.utils.Buffer;
import com.jn.langx.util.logging.Loggers;
import java.security.PublicKey;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.slf4j.Logger;

public class Eddsa25519PublicKeyCodec
extends AbstractPublicKeyCodec {
    private static final Logger logger = Loggers.getLogger(Eddsa25519PublicKeyCodec.class);

    public Eddsa25519PublicKeyCodec() {
        this.setName("ssh-ed25519");
    }

    @Override
    protected boolean isPublicKeyMatched(PublicKey publicKey, String algorithm) {
        return "EdDSA".equals(algorithm);
    }

    @Override
    public PublicKey decode(byte[] bytes) {
        try {
            Buffer.PlainBuffer buf = new Buffer.PlainBuffer(bytes);
            int keyLen = buf.readUInt32AsInt();
            byte[] p = new byte[keyLen];
            buf.readRawBytes(p);
            if (logger.isDebugEnabled()) {
                logger.debug("Key algo: {}, Key curve: 25519, Key Len: {}\np: {}", new Object[]{this.getName(), keyLen, Arrays.toString(p)});
            }
            EdDSANamedCurveSpec ed25519 = EdDSANamedCurveTable.getByName((String)"Ed25519");
            EdDSAPublicKeySpec publicSpec = new EdDSAPublicKeySpec(p, (EdDSAParameterSpec)ed25519);
            return new Ed25519PublicKey(publicSpec);
        }
        catch (Buffer.BufferException be) {
            throw new SshException(be);
        }
    }

    @Override
    public byte[] encode(PublicKey publicKey) {
        Buffer.PlainBuffer buf = new Buffer.PlainBuffer();
        EdDSAPublicKey key = (EdDSAPublicKey)publicKey;
        buf.putBytes(key.getAbyte());
        return buf.array();
    }
}

