/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.synergy;

import com.jn.agileway.ssh.client.AbstractSshConnectionFactory;
import com.jn.agileway.ssh.client.SshConnection;
import com.jn.agileway.ssh.client.impl.synergy.SynergyConnection;
import com.jn.agileway.ssh.client.impl.synergy.SynergyConnectionConfig;
import com.jn.agileway.ssh.client.impl.synergy.verifier.FromSynergyHostKeyVerificationAdapter;
import com.jn.agileway.ssh.client.utils.SshConfigs;
import com.jn.langx.annotation.OnClasses;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.logging.Loggers;
import com.sshtools.common.knownhosts.HostKeyVerification;
import com.sshtools.common.knownhosts.KnownHostsFile;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;

@OnClasses(value={"com.sshtools.client.SshClient"})
public class SynergyConnectionFactory
extends AbstractSshConnectionFactory<SynergyConnectionConfig> {
    private static final Logger logger = Loggers.getLogger(SynergyConnectionFactory.class);

    public SynergyConnectionFactory() {
        this.setName("synergy");
    }

    @Override
    protected Class<?> getDefaultConnectionClass() {
        return SynergyConnection.class;
    }

    @Override
    public SynergyConnectionConfig newConfig() {
        return new SynergyConnectionConfig();
    }

    private void setKnownHosts0(final SshConnection connection, SynergyConnectionConfig sshConfig) {
        List<File> paths = SshConfigs.getKnownHostsFiles(sshConfig.getKnownHostsPath());
        if (paths.isEmpty()) {
            paths = SshConfigs.getKnownHostsFiles(sshConfig.getKnownHostsPath(), false);
        }
        Collects.forEach(paths, (Consumer)new Consumer<File>(){

            public void accept(File file) {
                try {
                    KnownHostsFile f = new KnownHostsFile(file){

                        protected void onUnknownHost(String host, SshPublicKey key) throws SshException {
                            this.addEntry(key, null, new String[]{host});
                        }
                    };
                    connection.addHostKeyVerifier(new FromSynergyHostKeyVerificationAdapter((HostKeyVerification)f));
                }
                catch (Throwable ex) {
                    logger.error(ex.getMessage(), ex);
                }
            }
        });
    }
}

