/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.impl.jsch.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jn.agileway.ssh.client.impl.jsch.sftp.JschSftpFile;
import com.jn.agileway.ssh.client.impl.jsch.sftp.JschSftps;
import com.jn.agileway.ssh.client.sftp.AbstractSftpSession;
import com.jn.agileway.ssh.client.sftp.OpenMode;
import com.jn.agileway.ssh.client.sftp.SftpFile;
import com.jn.agileway.ssh.client.sftp.SftpResourceInfo;
import com.jn.agileway.ssh.client.sftp.Sftps;
import com.jn.agileway.ssh.client.sftp.attrs.FileAttrs;
import com.jn.agileway.ssh.client.sftp.exception.NoSuchFileSftpException;
import com.jn.agileway.ssh.client.sftp.exception.SftpException;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;

public class JschSftpSession
extends AbstractSftpSession {
    private ChannelSftp channel;

    public JschSftpSession(ChannelSftp channel) {
        this.channel = channel;
    }

    public ChannelSftp getChannel() {
        return this.channel;
    }

    @Override
    public int getProtocolVersion() throws SftpException {
        try {
            return this.channel.getServerVersion();
        }
        catch (com.jcraft.jsch.SftpException ex) {
            throw JschSftps.wrapSftpException(ex);
        }
    }

    @Override
    protected List<SftpResourceInfo> doListFiles(final String directory) throws SftpException {
        try {
            Vector vector = this.channel.ls(directory);
            return Pipeline.of((Iterable)vector).filter((Predicate)new Predicate<ChannelSftp.LsEntry>(){

                public boolean test(ChannelSftp.LsEntry entry) {
                    return !".".equals(entry.getFilename()) && !"..".equals(entry.getFilename());
                }
            }).map((Function)new Function<ChannelSftp.LsEntry, SftpResourceInfo>(){

                public SftpResourceInfo apply(ChannelSftp.LsEntry entry) {
                    FileAttrs attrs = JschSftps.fromSftpATTRS(entry.getAttrs());
                    return new SftpResourceInfo(directory + "/" + entry.getFilename(), attrs);
                }
            }).asList();
        }
        catch (com.jcraft.jsch.SftpException ex) {
            throw JschSftps.wrapSftpException(ex);
        }
    }

    @Override
    public SftpFile open(String filepath, int openMode, FileAttrs attrs) throws SftpException {
        if (!Sftps.exists(this, filepath)) {
            if (OpenMode.isCreatable(openMode)) {
                try {
                    this.channel.put((InputStream)new ByteArrayInputStream(new byte[0]), filepath, 0);
                }
                catch (com.jcraft.jsch.SftpException ex) {
                    throw JschSftps.wrapSftpException(ex);
                }
            } else {
                throw new NoSuchFileSftpException(StringTemplates.formatWithPlaceholder((String)"no such file: {}", (Object[])new Object[]{filepath}));
            }
        }
        return new JschSftpFile(this, filepath);
    }

    @Override
    public void createSymlink(String src, String target) throws SftpException {
        try {
            this.channel.symlink(src, target);
        }
        catch (com.jcraft.jsch.SftpException ex) {
            throw JschSftps.wrapSftpException(ex);
        }
    }

    @Override
    public String readLink(String path) throws SftpException {
        try {
            return this.channel.readlink(path);
        }
        catch (com.jcraft.jsch.SftpException ex) {
            throw JschSftps.wrapSftpException(ex);
        }
    }

    @Override
    public String canonicalPath(String path) throws SftpException {
        try {
            return this.channel.realpath(path);
        }
        catch (com.jcraft.jsch.SftpException ex) {
            throw JschSftps.wrapSftpException(ex);
        }
    }

    @Override
    public FileAttrs stat(String filepath) throws SftpException {
        try {
            SftpATTRS sftpATTRS = this.channel.stat(filepath);
            return JschSftps.fromSftpATTRS(sftpATTRS);
        }
        catch (com.jcraft.jsch.SftpException ex) {
            throw JschSftps.wrapSftpException(ex);
        }
    }

    @Override
    public FileAttrs lstat(String filepath) throws SftpException {
        try {
            SftpATTRS sftpATTRS = this.channel.lstat(filepath);
            return JschSftps.fromSftpATTRS(sftpATTRS);
        }
        catch (com.jcraft.jsch.SftpException ex) {
            throw JschSftps.wrapSftpException(ex);
        }
    }

    @Override
    public void setStat(String path, FileAttrs attrs) throws SftpException {
        try {
            SftpATTRS sftpATTRS = this.channel.lstat(path);
            sftpATTRS = JschSftps.toSftpATTRS(sftpATTRS, attrs);
            this.channel.setStat(path, sftpATTRS);
        }
        catch (com.jcraft.jsch.SftpException ex) {
            throw JschSftps.wrapSftpException(ex);
        }
    }

    @Override
    public void mkdir(String directory, FileAttrs attributes) throws SftpException {
        try {
            this.channel.mkdir(directory);
        }
        catch (com.jcraft.jsch.SftpException ex) {
            throw JschSftps.wrapSftpException(ex);
        }
    }

    @Override
    public void rmdir(String directory) throws SftpException {
        try {
            this.channel.rmdir(directory);
        }
        catch (com.jcraft.jsch.SftpException ex) {
            throw JschSftps.wrapSftpException(ex);
        }
    }

    @Override
    public void rm(String filepath) throws SftpException {
        try {
            this.channel.rm(filepath);
        }
        catch (com.jcraft.jsch.SftpException ex) {
            throw JschSftps.wrapSftpException(ex);
        }
    }

    @Override
    public void mv(String oldFilepath, String newFilepath) throws SftpException {
        try {
            this.channel.rename(oldFilepath, newFilepath);
        }
        catch (com.jcraft.jsch.SftpException ex) {
            throw JschSftps.wrapSftpException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.disconnect();
    }
}

