/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client;

import com.jn.agileway.ssh.client.SshConnection;
import com.jn.agileway.ssh.client.SshException;
import com.jn.agileway.ssh.client.channel.SessionedChannel;
import com.jn.agileway.ssh.client.supports.command.SshCommandResponse;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.logging.Loggers;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.slf4j.Logger;

public class SshClients {
    private static final Logger logger = Loggers.getLogger(SshClients.class);

    public static SshCommandResponse exec(@NonNull SshConnection connection, @NonNull String command) throws SshException {
        return SshClients.exec(connection, null, null, command, null);
    }

    public static SshCommandResponse exec(@NonNull SshConnection connection, @Nullable Map<String, String> environmentVariables, @Nullable String workingDirectory, @NonNull String command, @Nullable String encoding) throws SshException {
        return SshClients.exec(connection, environmentVariables, null, workingDirectory, command, encoding);
    }

    public static SshCommandResponse exec(@NonNull SshConnection connection, @Nullable Map<String, String> environmentVariables, @Nullable Supplier<Map<String, String>, String> environmentSettingsSupplier, @Nullable String workingDirectory, @NonNull String command, @Nullable String encoding) throws SshException {
        Preconditions.checkState((connection != null && connection.isConnected() && !connection.isClosed() ? 1 : 0) != 0, (String)"connection status invalid");
        Preconditions.checkNotEmpty((Object)command, (String)"the command is not supplied");
        Charset charset = Charsets.UTF_8;
        if (Strings.isNotEmpty((String)encoding)) {
            try {
                charset = Charsets.getCharset((String)encoding);
            }
            catch (Throwable ex) {
                logger.warn("The encoding is invalid : {}", (Object)encoding);
            }
        }
        final SessionedChannel channel = connection.openSession();
        if (Strings.isNotEmpty((String)workingDirectory)) {
            workingDirectory = workingDirectory.replace("\\", "/");
            command = "cd " + workingDirectory + ";" + command;
        }
        if (Emptys.isNotEmpty(environmentVariables)) {
            String envs = null;
            if (environmentSettingsSupplier != null) {
                envs = (String)environmentSettingsSupplier.get(environmentVariables);
            }
            if (Strings.isNotEmpty(envs)) {
                command = envs + command;
            } else {
                Collects.forEach(environmentVariables, (Consumer2)new Consumer2<String, String>(){

                    public void accept(String variable, String value) {
                        channel.env(variable, value);
                    }
                });
            }
        }
        channel.exec(command);
        int exitStatus = channel.getExitStatus();
        SshCommandResponse response = new SshCommandResponse();
        response.setExitStatus(exitStatus);
        try {
            if (exitStatus != 0) {
                InputStream errorInputStream = channel.getErrorInputStream();
                byte[] errorContent = IOs.toByteArray((InputStream)errorInputStream);
                String error = new String(errorContent, charset);
                response.setExitErrorMessage(error);
            } else {
                InputStream inputStream = channel.getInputStream();
                byte[] bytes = IOs.toByteArray((InputStream)inputStream);
                String content = new String(bytes, charset);
                response.setResult(content);
            }
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
        }
        return response;
    }

    public static int getUid(SshConnection connection) {
        SshCommandResponse response = SshClients.exec(connection, "id -u");
        if (!response.hasError()) {
            return Integer.parseInt(response.getResult());
        }
        return -1;
    }

    public static int[] getGroupIds(SshConnection connection) {
        SshCommandResponse response = SshClients.exec(connection, "id -G");
        if (!response.hasError()) {
            String[] groups = response.getResult().trim().split("\\s+");
            int[] groupsIds = new int[groups.length];
            for (int i = 0; i < groups.length; ++i) {
                groupsIds[i] = Integer.parseInt(groups[i]);
            }
            return groupsIds;
        }
        return null;
    }
}

