/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.redis.l2cache;

import com.jn.agileway.redis.core.RedisTemplate;
import com.jn.agileway.redis.core.key.RedisKeyWrapper;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.cache.BaseCache;
import com.jn.langx.cache.Loader;
import com.jn.langx.cache.RemoveCause;
import com.jn.langx.cache.RemoveListener;
import com.jn.langx.cache.RemoveListeners;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.timing.timer.Timeout;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.BoundValueOperations;

public class RedisCache<V>
extends BaseCache<String, V> {
    @NonNull
    private RedisTemplate<String, V> redisTemplate;
    @Nullable
    private Loader<String, V> loader;
    @Nullable
    private RemoveListener removeListener = RemoveListeners.noop();
    @NonNull
    private RedisKeyWrapper keyWrapper = new RedisKeyWrapper().prefix("iredis:cache");

    public void set(String key, V value) {
        BoundValueOperations valueOperations = this.redisTemplate.boundValueOps(this.keyWrapper.wrap(key));
        valueOperations.set(value);
    }

    public void set(String key, V value, long expire) {
        long now = System.currentTimeMillis();
        long ttl = expire - now;
        this.set(key, value, ttl, TimeUnit.MILLISECONDS);
    }

    public void set(String key, V value, long ttl, TimeUnit timeUnit) {
        BoundValueOperations valueOperations = this.redisTemplate.boundValueOps(this.keyWrapper.wrap(key));
        if (ttl < 0L) {
            valueOperations.set(value);
        }
        if (ttl > 0L) {
            valueOperations.set(value, ttl, timeUnit);
        }
    }

    public V get(String key) {
        Object v = this.getFromRedis(key);
        if (v == null && this.loader != null && (v = this.loader.load((Object)key)) != null) {
            this.set(key, v);
        }
        return v;
    }

    private V getFromRedis(String unwrappedKey) {
        Object v = null;
        BoundValueOperations valueOperations = this.redisTemplate.boundValueOps(this.keyWrapper.wrap(unwrappedKey));
        v = valueOperations.get();
        return (V)v;
    }

    private V getAndUpdateExpireTime(String key, long durationMills) {
        return (V)this.redisTemplate.executeScript("GetAndUpdateExpireTime", Collects.asList((Object[])new String[]{this.keyWrapper.wrap(key)}), durationMills);
    }

    public Map<String, V> getAll(Iterable<String> keys) {
        List<String> keyList = this.keyWrapper.wrap(keys);
        final List values = this.redisTemplate.opsForValue().multiGet(keyList);
        final HashMap map = new HashMap();
        if (Emptys.isNotEmpty((Object)values)) {
            Collects.forEach(keyList, (Consumer2)new Consumer2<Integer, String>(){

                public void accept(Integer index, String wrappedKey) {
                    String unwrappedKey = RedisCache.this.keyWrapper.unwrap(wrappedKey);
                    Object v = values.get(index);
                    if (v == null && RedisCache.this.loader != null && (v = RedisCache.this.loader.load((Object)unwrappedKey)) != null) {
                        RedisCache.this.set(unwrappedKey, v);
                    }
                    map.put(unwrappedKey, v);
                }
            });
        }
        return map;
    }

    public Map<String, V> getAllIfPresent(Iterable<String> keys) {
        List keyList = Collects.asList(keys);
        final List values = this.redisTemplate.opsForValue().multiGet((Collection)keyList);
        final HashMap map = new HashMap();
        Collects.forEach((Collection)keyList, (Consumer2)new Consumer2<Integer, String>(){

            public void accept(Integer index, String key) {
                Object v = values.get(index);
                if (v != null) {
                    map.put(key, v);
                }
            }
        });
        return map;
    }

    public V getIfPresent(String key) {
        BoundValueOperations valueOperations = this.redisTemplate.boundValueOps(key);
        return (V)valueOperations.get();
    }

    public V get(String key, Supplier<String, V> loader) {
        Object value = this.getFromRedis(key);
        if (value == null) {
            if (loader != null) {
                value = loader.get((Object)key);
            }
            if (value == null && this.loader != null) {
                value = this.loader.load((Object)key);
            }
        }
        if (value != null) {
            this.set(key, value);
        }
        return null;
    }

    public V remove(String key) {
        Object ret = this.redisTemplate.executeScript("GetAndRemove", Collects.asList((Object[])new String[]{this.keyWrapper.wrap(key)}), new Object[0]);
        this.removeListener.onRemove((Object)key, ret, RemoveCause.EXPLICIT);
        return (V)ret;
    }

    public List<V> remove(Collection<String> keys) {
        return (List)this.redisTemplate.executeScript("mGetAndRemove", this.keyWrapper.wrap(keys), new Object[0]);
    }

    public void refresh(String key) {
        if (this.loader != null) {
            Object v = this.loader.load((Object)key);
            if (v == null) {
                this.redisTemplate.delete(this.keyWrapper.wrap(key));
            } else {
                this.set(key, v);
                this.removeListener.onRemove((Object)key, v, RemoveCause.REPLACED);
            }
        }
    }

    protected void refreshAllAsync(@Nullable Timeout timeout) {
        Set<String> keys = this.keys();
        Pipeline.of(keys).map((Function)new Function<String, String>(){

            public String apply(String wrappedKey) {
                return RedisCache.this.keyWrapper.unwrap(wrappedKey);
            }
        }).forEach((Consumer)new Consumer<String>(){

            public void accept(String key) {
                RedisCache.this.refresh(key);
            }
        });
    }

    public void evictExpired() {
    }

    public Set<String> keys() {
        return this.redisTemplate.keys(this.keyWrapper.wrap("*"));
    }

    public void clean() {
        Set<String> wrappedKeys = this.keys();
        this.redisTemplate.delete(wrappedKeys);
    }

    public int size() {
        Set<String> wrappedKeys = this.keys();
        return Objs.length(wrappedKeys);
    }

    public Map<String, V> toMap() {
        Set<String> wrappedKeys = this.keys();
        final List values = this.redisTemplate.opsForValue().multiGet(wrappedKeys);
        final HashMap map = Collects.emptyHashMap();
        Collects.forEach(wrappedKeys, (Consumer2)new Consumer2<Integer, String>(){

            public void accept(Integer index, String wrappedKey) {
                String unwrappedKey = RedisCache.this.keyWrapper.unwrap(wrappedKey);
                map.put(unwrappedKey, values.get(index));
            }
        });
        return map;
    }

    public void setRemoveListener(RemoveListener removeListener) {
        if (removeListener != null) {
            this.removeListener = removeListener;
        }
    }

    public RedisTemplate<String, V> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<String, V> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public Loader<String, V> getLoader() {
        return this.loader;
    }

    public void setLoader(Loader<String, V> loader) {
        this.loader = loader;
    }

    public RemoveListener getRemoveListener() {
        return this.removeListener;
    }

    public RedisKeyWrapper getKeyWrapper() {
        return this.keyWrapper;
    }

    public void setKeyWrapper(RedisKeyWrapper keyWrapper) {
        if (keyWrapper != null) {
            this.keyWrapper = keyWrapper;
        }
    }

    public void hashDelete(String key, Object ... fields) {
        String wrappedKey = this.keyWrapper.wrap(key);
        this.redisTemplate.opsForHash().delete((Object)wrappedKey, fields);
    }

    public <HK, HV> void hashMultiGet(String key, List<HK> fields) {
        String wrappedKey = this.keyWrapper.wrap(key);
        fields = Pipeline.of(fields).clearNulls().asList();
        HashMap map = new HashMap();
        List f = fields;
        List hashValues = this.redisTemplate.opsForHash().multiGet((Object)wrappedKey, (Collection)f);
        for (int i = 0; i < fields.size(); ++i) {
            Object hk = fields.get(i);
            Object hv = hashValues.get(i);
            map.put(hk, hv);
        }
    }

    public void hashPut(String key, Object field, Object fieldValue) {
        String wrappedKey = this.keyWrapper.wrap(key);
        this.redisTemplate.opsForHash().put((Object)wrappedKey, field, fieldValue);
    }

    public void hashIncrement(String key, Object field, double delta) {
        String wrappedKey = this.keyWrapper.wrap(key);
        this.redisTemplate.opsForHash().increment((Object)wrappedKey, field, delta);
    }

    public void hashIncrement(String key, Object field, long delta) {
        String wrappedKey = this.keyWrapper.wrap(key);
        this.redisTemplate.opsForHash().increment((Object)wrappedKey, field, delta);
    }
}

