/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.redis.counter;

import com.jn.agileway.redis.core.RedisTemplate;
import com.jn.agileway.redis.counter.DistributedCounter;

public class SimpleDistributedCounter
implements DistributedCounter {
    private RedisTemplate redisTemplate;
    private String key;

    public SimpleDistributedCounter(RedisTemplate redisTemplate, String key) {
        this.setRedisTemplate(redisTemplate);
        this.setCounterKey(key);
    }

    public Long getAndIncrement() {
        return this.getAndIncrement(1L);
    }

    public Long getAndIncrement(Long delta) {
        Long ret = this.get();
        this.increment(delta);
        return ret;
    }

    public Long increment() {
        return this.increment(1L);
    }

    public Long increment(Long delta) {
        return this.redisTemplate.opsForValue().increment((Object)this.key, delta.longValue());
    }

    public Long decrement() {
        return this.decrement(1L);
    }

    public Long decrement(Long delta) {
        return this.redisTemplate.opsForValue().increment((Object)this.key, -delta.longValue());
    }

    public Long get() {
        return (Long)this.redisTemplate.opsForValue().get((Object)this.key);
    }

    public void set(Long aLong) {
        this.redisTemplate.opsForValue().set((Object)this.key, (Object)aLong);
    }

    @Override
    public void clear() {
        this.redisTemplate.delete(this.key);
    }

    @Override
    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    @Override
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public String getCounterKey() {
        return this.key;
    }

    @Override
    public void setCounterKey(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }
}

