/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.redis.core.key;

import com.jn.agileway.redis.core.key.RedisKeyProperties;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class RedisKeyWrapper {
    public static final String SEPARATOR_DEFAULT = ":";
    public static final String PREFIX_DEFAULT = "";
    private String prefix = "";
    private String separation = ":";

    public RedisKeyWrapper() {
    }

    public RedisKeyWrapper(RedisKeyProperties properties) {
        this.prefix(properties.getPrefix());
        this.separation(properties.getSeparation());
    }

    public RedisKeyWrapper prefix(String prefix) {
        if (Strings.isNotBlank((String)prefix)) {
            this.prefix = prefix;
        }
        return this;
    }

    public String prefix() {
        return this.prefix;
    }

    public String separation() {
        return this.separation;
    }

    public RedisKeyWrapper separation(String separation) {
        if (Strings.isNotBlank((String)separation)) {
            this.separation = separation;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisKeyWrapper that = (RedisKeyWrapper)o;
        if (!Objects.equals(this.prefix, that.prefix)) {
            return false;
        }
        return Objects.equals(this.separation, that.separation);
    }

    public int hashCode() {
        return Objs.hash((Object[])new Object[]{this.prefix, this.separation});
    }

    public String toString() {
        return "RedisKeyWrapper{prefix='" + this.prefix + '\'' + ", separation='" + this.separation + '\'' + '}';
    }

    public String wrap(String key) {
        Preconditions.checkNotNull((Object)key);
        if (Strings.isBlank((String)this.prefix)) {
            return key;
        }
        String prefix = this.prefix + this.separation;
        if (key.startsWith(prefix)) {
            return key;
        }
        return prefix + key;
    }

    public List<String> wrap(Iterable<String> keys) {
        return Pipeline.of(keys).map((Function)new Function<String, String>(){

            public String apply(String key) {
                return RedisKeyWrapper.this.wrap(key);
            }
        }).asList();
    }

    public List<String> unwrap(Iterable<String> keys) {
        return Pipeline.of(keys).map((Function)new Function<String, String>(){

            public String apply(String key) {
                return RedisKeyWrapper.this.unwrap(key);
            }
        }).asList();
    }

    public String unwrap(String key) {
        Preconditions.checkNotNull((Object)key);
        if (Strings.isBlank((String)this.prefix)) {
            return key;
        }
        String prefix = this.prefix + this.separation;
        if (key.startsWith(prefix) && key.length() > prefix.length()) {
            return key.substring(prefix.length());
        }
        return key;
    }

    public static String wrap(RedisKeyWrapper wrapper, String key) {
        return wrapper.wrap(key);
    }

    public static String unwrap(RedisKeyWrapper wrapper, String key) {
        return wrapper.unwrap(key);
    }

    public static <C extends Collection<String>> C unwrap(final RedisKeyWrapper wrapper, C keys) {
        List a = Pipeline.of(keys).map((Function)new Function<String, String>(){

            public String apply(String key) {
                return wrapper.unwrap(key);
            }
        }).asList();
        keys.clear();
        keys.addAll(a);
        return keys;
    }

    public static String[] unwrap(final RedisKeyWrapper wrapper, String ... keys) {
        return (String[])Pipeline.of((Object[])keys).map((Function)new Function<String, String>(){

            public String apply(String key) {
                return wrapper.unwrap(key);
            }
        }).toArray(String[].class);
    }

    public static <C extends Collection<String>> C wrap(final RedisKeyWrapper wrapper, C keys) {
        List a = Pipeline.of(keys).map((Function)new Function<String, String>(){

            public String apply(String key) {
                return wrapper.wrap(key);
            }
        }).asList();
        keys.clear();
        keys.addAll(a);
        return keys;
    }

    public static String[] wrap(final RedisKeyWrapper wrapper, String ... keys) {
        return (String[])Pipeline.of((Object[])keys).map((Function)new Function<String, String>(){

            public String apply(String key) {
                return wrapper.wrap(key);
            }
        }).toArray(String[].class);
    }
}

