/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.redis.collection;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisOperations;

public class RedisMap<K, V>
implements Map<K, V> {
    private BoundHashOperations ops;
    private String key;

    public RedisMap(RedisOperations<String, Map<K, V>> redisTemplate, String key) {
        this.ops = redisTemplate.boundHashOps((Object)key);
        this.key = key;
    }

    @Override
    public int size() {
        return Long.valueOf(this.longSize()).intValue();
    }

    public long longSize() {
        return this.ops.size();
    }

    @Override
    public boolean isEmpty() {
        return this.longSize() == 0L;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.ops.hasKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.ops.values().contains(value);
    }

    @Override
    public V get(Object key) {
        return (V)this.ops.get(key);
    }

    @Override
    public V put(K key, V value) {
        V old = this.get(key);
        this.ops.put(key, value);
        return old;
    }

    @Override
    public V remove(Object key) {
        V old = this.get(key);
        this.ops.delete(new Object[]{key});
        return old;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.ops.putAll(m);
    }

    @Override
    public void clear() {
        this.ops.delete(new Object[]{this.ops.keys()});
    }

    @Override
    public Set<K> keySet() {
        return this.ops.keys();
    }

    @Override
    public Collection<V> values() {
        return this.ops.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.ops.entries().entrySet();
    }
}

