/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class FieldPredicates {
    public static Predicate<Field> named(String name) {
        return field -> Pattern.compile(name).matcher(field.getName()).matches();
    }

    public static Predicate<Field> ofType(Class<?> type) {
        return field -> field.getType().equals(type);
    }

    public static Predicate<Field> inClass(Class<?> clazz) {
        return field -> field.getDeclaringClass().equals(clazz);
    }

    public static Predicate<Field> isAnnotatedWith(Class<? extends Annotation> ... annotations) {
        return field -> {
            for (Class annotation : annotations) {
                if (!field.isAnnotationPresent(annotation)) continue;
                return true;
            }
            return false;
        };
    }

    public static Predicate<Field> hasModifiers(Integer modifiers) {
        return field -> (modifiers & field.getModifiers()) == modifiers;
    }
}

