/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans;

import io.github.benas.randombeans.RandomizationContextStackItem;
import io.github.benas.randombeans.api.EnhancedRandomParameters;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

class RandomizationContext {
    private final EnhancedRandomParameters parameters;
    private final Set<String> excludedFields;
    private final Map<Class<?>, List<Object>> populatedBeans = new IdentityHashMap();
    private final Stack<RandomizationContextStackItem> stack = new Stack();

    RandomizationContext(EnhancedRandomParameters parameters, String ... excludedFields) {
        this.parameters = parameters;
        this.excludedFields = new HashSet<String>(this.toLowerCase(Arrays.asList(excludedFields)));
    }

    void addPopulatedBean(Class<?> type, Object object) {
        int objectPoolSize = this.parameters.getObjectPoolSize();
        List<Object> objects = this.populatedBeans.get(type);
        if (objects == null) {
            objects = new ArrayList<Object>(objectPoolSize);
        }
        if (objects.size() < objectPoolSize) {
            objects.add(object);
        }
        this.populatedBeans.put(type, objects);
    }

    Object getPopulatedBean(Class<?> type) {
        int actualPoolSize = this.populatedBeans.get(type).size();
        int randomIndex = actualPoolSize > 1 ? this.nextInt(0, actualPoolSize) : 0;
        return this.populatedBeans.get(type).get(randomIndex);
    }

    boolean hasAlreadyRandomizedType(Class<?> type) {
        return this.populatedBeans.containsKey(type) && this.populatedBeans.get(type).size() == this.parameters.getObjectPoolSize();
    }

    Set<String> getExcludedFields() {
        return this.excludedFields;
    }

    void pushStackItem(RandomizationContextStackItem field) {
        this.stack.push(field);
    }

    void popStackItem() {
        this.stack.pop();
    }

    String getFieldFullName(Field field) {
        List<String> pathToField = this.getStackedFieldNames();
        pathToField.add(field.getName());
        return String.join((CharSequence)".", this.toLowerCase(pathToField));
    }

    boolean hasExceededRandomizationDepth() {
        int currentRandomizationDepth = this.stack.size();
        return currentRandomizationDepth > this.parameters.getRandomizationDepth();
    }

    private List<String> getStackedFieldNames() {
        return this.stack.stream().map(i -> i.getField().getName()).collect(Collectors.toList());
    }

    private List<String> toLowerCase(List<String> strings) {
        return strings.stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    private int nextInt(int startInclusive, int endExclusive) {
        return startInclusive + new Random().nextInt(endExclusive - startInclusive);
    }
}

