/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.range;

import io.github.benas.randombeans.randomizers.range.AbstractRangeRandomizer;

public class ByteRangeRandomizer
extends AbstractRangeRandomizer<Byte> {
    public ByteRangeRandomizer(Byte min, Byte max) {
        super(min, max);
    }

    public ByteRangeRandomizer(Byte min, Byte max, long seed) {
        super(min, max, seed);
    }

    public static ByteRangeRandomizer aNewByteRangeRandomizer(Byte min, Byte max) {
        return new ByteRangeRandomizer(min, max);
    }

    public static ByteRangeRandomizer aNewByteRangeRandomizer(Byte min, Byte max, long seed) {
        return new ByteRangeRandomizer(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if ((Byte)this.min > (Byte)this.max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
    }

    @Override
    public Byte getRandomValue() {
        return (byte)this.nextLong(((Byte)this.min).byteValue(), ((Byte)this.max).byteValue());
    }

    @Override
    protected Byte getDefaultMaxValue() {
        return (byte)127;
    }

    @Override
    protected Byte getDefaultMinValue() {
        return (byte)-128;
    }
}

