/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.util;

import io.github.benas.randombeans.util.ReflectionUtils;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

abstract class FastClasspathScannerFacade {
    private static final ConcurrentHashMap<Class<?>, List<Class<?>>> typeToConcreteSubTypes = new ConcurrentHashMap();
    private static final FastClasspathScanner classpathScanner = new FastClasspathScanner(new String[0]);

    FastClasspathScannerFacade() {
    }

    public static <T> List<Class<?>> getPublicConcreteSubTypesOf(Class<T> type) {
        List<Class<?>> concreteSubTypes = typeToConcreteSubTypes.get(type);
        if (concreteSubTypes == null) {
            concreteSubTypes = FastClasspathScannerFacade.searchForPublicConcreteSubTypesOf(type);
            typeToConcreteSubTypes.putIfAbsent(type, Collections.unmodifiableList(concreteSubTypes));
        }
        return concreteSubTypes;
    }

    private static <T> List<Class<?>> searchForPublicConcreteSubTypesOf(Class<T> type) {
        List subTypes = type.isInterface() ? classpathScanner.getNamesOfClassesImplementing(type) : classpathScanner.getNamesOfSubclassesOf(type);
        return subTypes.stream().map(className -> {
            try {
                ClassLoader classloader = Thread.currentThread().getContextClassLoader();
                if (classloader == null) {
                    classloader = FastClasspathScannerFacade.class.getClassLoader();
                }
                return classloader.loadClass((String)className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError ignored) {
                return null;
            }
        }).filter(Objects::nonNull).filter(currentSubType -> ReflectionUtils.isPublic(currentSubType) && !ReflectionUtils.isAbstract(currentSubType)).collect(Collectors.toList());
    }

    static {
        classpathScanner.scan();
    }
}

