/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.text;

import io.github.benas.randombeans.randomizers.AbstractRandomizer;
import io.github.benas.randombeans.randomizers.text.CharacterRandomizer;
import java.nio.charset.Charset;

public class StringRandomizer
extends AbstractRandomizer<String> {
    private final CharacterRandomizer characterRandomizer;
    private int maxLength = 32;

    public StringRandomizer() {
        this.characterRandomizer = new CharacterRandomizer();
    }

    public StringRandomizer(Charset charset) {
        this.characterRandomizer = new CharacterRandomizer(charset);
    }

    public StringRandomizer(int maxLength) {
        this.maxLength = maxLength;
        this.characterRandomizer = new CharacterRandomizer();
    }

    public StringRandomizer(long seed) {
        super(seed);
        this.characterRandomizer = new CharacterRandomizer(seed);
    }

    public StringRandomizer(Charset charset, long seed) {
        super(seed);
        this.characterRandomizer = new CharacterRandomizer(charset, seed);
    }

    public StringRandomizer(int maxLength, long seed) {
        super(seed);
        this.maxLength = maxLength;
        this.characterRandomizer = new CharacterRandomizer(seed);
    }

    public StringRandomizer(Charset charset, int maxLength, long seed) {
        super(seed);
        this.maxLength = maxLength;
        this.characterRandomizer = new CharacterRandomizer(charset, seed);
    }

    public static StringRandomizer aNewStringRandomizer() {
        return new StringRandomizer();
    }

    public static StringRandomizer aNewStringRandomizer(Charset charset) {
        return new StringRandomizer(charset);
    }

    public static StringRandomizer aNewStringRandomizer(int maxLength) {
        return new StringRandomizer(maxLength);
    }

    public static StringRandomizer aNewStringRandomizer(long seed) {
        return new StringRandomizer(seed);
    }

    public static StringRandomizer aNewStringRandomizer(Charset charset, long seed) {
        return new StringRandomizer(charset, seed);
    }

    public static StringRandomizer aNewStringRandomizer(int maxLength, long seed) {
        return new StringRandomizer(maxLength, seed);
    }

    public static StringRandomizer aNewStringRandomizer(Charset charset, int maxLength, long seed) {
        return new StringRandomizer(charset, maxLength, seed);
    }

    @Override
    public String getRandomValue() {
        StringBuilder stringBuilder = new StringBuilder();
        int length = 1 + this.random.nextInt(this.maxLength);
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(this.characterRandomizer.getRandomValue());
        }
        return stringBuilder.toString();
    }
}

