/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans;

import io.github.benas.randombeans.ArrayPopulator;
import io.github.benas.randombeans.CollectionPopulator;
import io.github.benas.randombeans.FieldExclusionChecker;
import io.github.benas.randombeans.FieldPopulator;
import io.github.benas.randombeans.MapPopulator;
import io.github.benas.randombeans.ObjectFactory;
import io.github.benas.randombeans.PopulatorContext;
import io.github.benas.randombeans.RandomizerProvider;
import io.github.benas.randombeans.api.EnhancedRandom;
import io.github.benas.randombeans.api.EnhancedRandomParameters;
import io.github.benas.randombeans.api.ObjectGenerationException;
import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.api.RandomizerRegistry;
import io.github.benas.randombeans.randomizers.misc.EnumRandomizer;
import io.github.benas.randombeans.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

class EnhancedRandomImpl
extends EnhancedRandom {
    private EnhancedRandomParameters parameters;
    private final FieldPopulator fieldPopulator;
    private final ArrayPopulator arrayPopulator;
    private final CollectionPopulator collectionPopulator;
    private final MapPopulator mapPopulator;
    private final RandomizerProvider randomizerProvider;
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final FieldExclusionChecker fieldExclusionChecker;

    EnhancedRandomImpl(Set<RandomizerRegistry> registries) {
        this.randomizerProvider = new RandomizerProvider(registries);
        this.arrayPopulator = new ArrayPopulator(this, this.randomizerProvider);
        this.collectionPopulator = new CollectionPopulator(this, this.objectFactory);
        this.mapPopulator = new MapPopulator(this, this.objectFactory);
        this.fieldPopulator = new FieldPopulator(this, this.randomizerProvider, this.arrayPopulator, this.collectionPopulator, this.mapPopulator);
        this.fieldExclusionChecker = new FieldExclusionChecker();
    }

    @Override
    public <T> T nextObject(Class<T> type, String ... excludedFields) {
        return this.doPopulateBean(type, new PopulatorContext(excludedFields));
    }

    @Override
    public <T> Stream<T> objects(Class<T> type, int streamSize, String ... excludedFields) {
        if (streamSize < 0) {
            throw new IllegalArgumentException("The stream size must be positive");
        }
        Stream.Builder<T> streamBuilder = Stream.builder();
        for (int i = 0; i < streamSize; ++i) {
            T bean = this.nextObject(type, excludedFields);
            streamBuilder.add(bean);
        }
        return streamBuilder.build();
    }

    <T> T doPopulateBean(Class<T> type, PopulatorContext context) {
        try {
            Randomizer<?> randomizer = this.randomizerProvider.getRandomizerByType(type);
            if (randomizer != null) {
                return (T)randomizer.getRandomValue();
            }
            if (!ReflectionUtils.isIntrospectable(type)) {
                return this.randomize(type, context);
            }
            if (context.hasRandomizedType(type)) {
                return (T)context.getPopulatedBean(type);
            }
            T result = this.objectFactory.createInstance(type);
            context.addPopulatedBean(type, result);
            List<Field> fields = ReflectionUtils.getDeclaredFields(result);
            fields.addAll(ReflectionUtils.getInheritedFields(type));
            this.populateFields(fields, result, context);
            return result;
        }
        catch (Exception | InstantiationError e) {
            throw new ObjectGenerationException("Unable to generate a random instance of type " + type, e);
        }
    }

    private <T> T randomize(Class<T> type, PopulatorContext context) {
        if (ReflectionUtils.isEnumType(type)) {
            return (T)new EnumRandomizer<T>(type, this.parameters.getSeed()).getRandomValue();
        }
        if (ReflectionUtils.isArrayType(type)) {
            return (T)this.arrayPopulator.getRandomArray(type, context);
        }
        if (ReflectionUtils.isCollectionType(type)) {
            return (T)this.collectionPopulator.getEmptyImplementationForCollectionInterface(type);
        }
        if (ReflectionUtils.isMapType(type)) {
            return (T)this.mapPopulator.getEmptyImplementationForMapInterface(type);
        }
        return null;
    }

    private <T> void populateFields(List<Field> fields, T result, PopulatorContext context) throws IllegalAccessException {
        for (Field field : fields) {
            this.populateField(field, result, context);
        }
    }

    private <T> void populateField(Field field, T result, PopulatorContext context) throws IllegalAccessException {
        if (!this.fieldExclusionChecker.shouldBeExcluded(field, context)) {
            this.fieldPopulator.populateField(result, field, context);
        }
    }

    int getRandomCollectionSize() {
        return 1 + this.nextInt(this.parameters.getMaxCollectionSize());
    }

    public void setParameters(EnhancedRandomParameters parameters) {
        this.parameters = parameters;
        super.setSeed(parameters.getSeed());
        this.fieldPopulator.setScanClasspathForConcreteTypes(parameters.isScanClasspathForConcreteTypes());
        this.objectFactory.setScanClasspathForConcreteTypes(parameters.isScanClasspathForConcreteTypes());
    }
}

