/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans;

import io.github.benas.randombeans.PopulatorContext;
import io.github.benas.randombeans.annotation.Exclude;
import io.github.benas.randombeans.util.ReflectionUtils;
import java.lang.reflect.Field;

class FieldExclusionChecker {
    FieldExclusionChecker() {
    }

    boolean shouldBeExcluded(Field field, PopulatorContext context) {
        if (field.isAnnotationPresent(Exclude.class)) {
            return true;
        }
        if (ReflectionUtils.isStatic(field)) {
            return true;
        }
        if (context.getExcludedFields().length == 0) {
            return false;
        }
        String fieldFullName = context.getFieldFullName(field);
        for (String excludedFieldName : context.getExcludedFields()) {
            if (!fieldFullName.equalsIgnoreCase(excludedFieldName)) continue;
            return true;
        }
        return false;
    }
}

