/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans;

import io.github.benas.randombeans.ArrayPopulator;
import io.github.benas.randombeans.CollectionPopulator;
import io.github.benas.randombeans.FieldExclusionChecker;
import io.github.benas.randombeans.FieldPopulator;
import io.github.benas.randombeans.MapPopulator;
import io.github.benas.randombeans.ObjectFactory;
import io.github.benas.randombeans.PopulatorContext;
import io.github.benas.randombeans.RandomizerProvider;
import io.github.benas.randombeans.api.EnhancedRandom;
import io.github.benas.randombeans.api.ObjectGenerationException;
import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.api.RandomizerRegistry;
import io.github.benas.randombeans.randomizers.EnumRandomizer;
import io.github.benas.randombeans.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class EnhancedRandomImpl
extends EnhancedRandom {
    private long seed;
    private FieldPopulator fieldPopulator;
    private ArrayPopulator arrayPopulator;
    private CollectionPopulator collectionPopulator;
    private MapPopulator mapPopulator;
    private RandomizerProvider randomizerProvider;
    private ObjectFactory objectFactory = new ObjectFactory();
    private FieldExclusionChecker fieldExclusionChecker;

    EnhancedRandomImpl(Set<RandomizerRegistry> registries) {
        this.randomizerProvider = new RandomizerProvider(registries);
        this.arrayPopulator = new ArrayPopulator(this);
        this.collectionPopulator = new CollectionPopulator(this, this.objectFactory);
        this.mapPopulator = new MapPopulator(this, this.objectFactory);
        this.fieldPopulator = new FieldPopulator(this, this.randomizerProvider, this.arrayPopulator, this.collectionPopulator, this.mapPopulator);
        this.fieldExclusionChecker = new FieldExclusionChecker();
    }

    @Override
    public <T> T nextObject(Class<T> type, String ... excludedFields) {
        Randomizer<?> randomizer = this.randomizerProvider.getRandomizerByType(type);
        if (randomizer != null) {
            return (T)randomizer.getRandomValue();
        }
        return this.doPopulateBean(type, new PopulatorContext(excludedFields));
    }

    @Override
    public <T> List<T> nextObjects(Class<T> type, int size, String ... excludedFields) {
        if (size < 0) {
            throw new IllegalArgumentException("The size must be positive");
        }
        ArrayList<T> beans = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            T bean = this.nextObject(type, excludedFields);
            beans.add(bean);
        }
        return beans;
    }

    <T> T doPopulateBean(Class<T> type, PopulatorContext context) {
        try {
            if (!ReflectionUtils.isIntrospectable(type)) {
                return this.randomize(type, context);
            }
            if (context.hasRandomizedType(type)) {
                return (T)context.getPopulatedBean(type);
            }
            T result = this.objectFactory.createInstance(type);
            context.addPopulatedBean(type, result);
            List<Field> fields = ReflectionUtils.getDeclaredFields(result);
            fields.addAll(ReflectionUtils.getInheritedFields(type));
            this.populateFields(fields, result, context);
            return result;
        }
        catch (Exception | InstantiationError e) {
            throw new ObjectGenerationException("Unable to generate a random instance of type " + type, e);
        }
    }

    private <T> T randomize(Class<T> type, PopulatorContext context) {
        if (ReflectionUtils.isEnumType(type)) {
            return (T)new EnumRandomizer<T>(type, this.seed).getRandomValue();
        }
        if (ReflectionUtils.isArrayType(type)) {
            return (T)this.arrayPopulator.getRandomArray(type, context);
        }
        if (ReflectionUtils.isCollectionType(type)) {
            return (T)this.collectionPopulator.getEmptyImplementationForCollectionInterface(type);
        }
        if (ReflectionUtils.isMapType(type)) {
            return (T)this.mapPopulator.getEmptyImplementationForMapInterface(type);
        }
        return null;
    }

    private <T> void populateFields(List<Field> fields, T result, PopulatorContext context) throws IllegalAccessException {
        for (Field field : fields) {
            if (this.fieldExclusionChecker.shouldBeExcluded(field, context)) continue;
            this.fieldPopulator.populateField(result, field, context);
        }
    }

    void setScanClasspathForConcreteTypes(boolean scanClasspathForConcreteTypes) {
        this.fieldPopulator.setScanClasspathForConcreteTypes(scanClasspathForConcreteTypes);
        this.objectFactory.setScanClasspathForConcreteTypes(scanClasspathForConcreteTypes);
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        this.seed = seed;
    }
}

