/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.jpopulator.randomizers;

import io.github.benas.jpopulator.api.Randomizer;
import io.github.benas.jpopulator.util.ConstantsUtil;
import java.util.Collection;

public abstract class CollectionRandomizer<T>
implements Randomizer<Collection<T>> {
    protected int minElements;
    protected int maxElements;
    protected int nbElements;
    protected Randomizer<T> elementRandomizer;

    public CollectionRandomizer(Randomizer<T> elementRandomizer) {
        this(elementRandomizer, 0, (byte)Math.abs((byte)ConstantsUtil.RANDOM.nextInt()));
    }

    public CollectionRandomizer(Randomizer<T> elementRandomizer, int nbElements) {
        this(elementRandomizer, nbElements, nbElements);
    }

    public CollectionRandomizer(Randomizer<T> elementRandomizer, int minElements, int maxElements) {
        this.checkArguments(minElements, maxElements);
        this.elementRandomizer = elementRandomizer;
        this.minElements = minElements;
        this.maxElements = maxElements + 1;
        this.nbElements = ConstantsUtil.RANDOM.nextInt(this.maxElements - this.minElements) + this.minElements;
    }

    protected void checkArguments(int minElements, int maxElements) {
        if (minElements < 0) {
            throw new IllegalArgumentException("The minimum number of elements to generate must be positive");
        }
        if (minElements < 1) {
            throw new IllegalArgumentException("The maximum number of elements to generate must be greater than or equal to 1");
        }
        if (maxElements < minElements) {
            throw new IllegalArgumentException("The maximum number of elements should be greater than or equal to the minimum number of elements.");
        }
    }

    protected T getRandomElement() {
        return this.elementRandomizer.getRandomValue();
    }
}

