/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.jpopulator.impl;

import io.github.benas.jpopulator.api.Exclude;
import io.github.benas.jpopulator.api.Populator;
import io.github.benas.jpopulator.api.Randomizer;
import io.github.benas.jpopulator.impl.BeanValidationRandomizer;
import io.github.benas.jpopulator.impl.DefaultRandomizer;
import io.github.benas.jpopulator.impl.RandomizerDefinition;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Size;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Period;

public final class PopulatorImpl
implements Populator {
    private static final Logger LOGGER = Logger.getLogger(PopulatorImpl.class.getName());
    private Map<RandomizerDefinition, Randomizer> randomizers = new HashMap<RandomizerDefinition, Randomizer>();
    private final List<Class> supportedTypesList = new ArrayList<Class>();

    public PopulatorImpl() {
        Class[] supportedTypes = new Class[]{String.class, Character.TYPE, Character.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Double.TYPE, Double.class, Float.TYPE, Float.class, BigInteger.class, BigDecimal.class, AtomicLong.class, AtomicInteger.class, java.util.Date.class, Date.class, Time.class, Timestamp.class, Calendar.class, DateTime.class, LocalDate.class, LocalTime.class, LocalDateTime.class, Duration.class, Period.class, Interval.class, URL.class, URI.class};
        this.supportedTypesList.addAll(Arrays.asList(supportedTypes));
    }

    @Override
    public <T> T populateBean(Class<T> type, String ... excludedFields) {
        T result;
        try {
            if (type.isEnum()) {
                return (T)DefaultRandomizer.getRandomValue(type);
            }
            result = type.newInstance();
            ArrayList<Field> declaredFields = this.getDeclaredFields(result);
            declaredFields.addAll(this.getInheritedFields(type));
            for (Field field : declaredFields) {
                if (this.shouldExcludeField(field, excludedFields) || this.isStaticOrFinal(field)) continue;
                if (this.isCollectionType(field.getType())) {
                    this.populateCollectionType(result, field);
                    continue;
                }
                this.populateSimpleType(result, field);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, String.format("Unable to populate an instance of type %s", type), e);
            return null;
        }
        return result;
    }

    @Override
    public <T> List<T> populateBeans(Class<T> type, String ... excludedFields) {
        int size = new RandomDataGenerator().nextInt(1, Short.MAX_VALUE);
        return this.populateBeans(type, size, excludedFields);
    }

    @Override
    public <T> List<T> populateBeans(Class<T> type, int size, String ... excludedFields) {
        if (size < 0) {
            throw new IllegalArgumentException("The number of beans to populate must be positive.");
        }
        ArrayList<T> beans = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            T bean = this.populateBean(type, excludedFields);
            beans.add(bean);
        }
        return beans;
    }

    private <T> ArrayList<Field> getDeclaredFields(T result) {
        return new ArrayList<Field>(Arrays.asList(result.getClass().getDeclaredFields()));
    }

    private List<Field> getInheritedFields(Class clazz) {
        ArrayList<Field> inheritedFields = new ArrayList<Field>();
        while (clazz.getSuperclass() != null) {
            Class superclass = clazz.getSuperclass();
            inheritedFields.addAll(Arrays.asList(superclass.getDeclaredFields()));
            clazz = superclass;
        }
        return inheritedFields;
    }

    private void populateSimpleType(Object result, Field field) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> fieldType = field.getType();
        String fieldName = field.getName();
        Class<?> resultClass = result.getClass();
        Object object = this.customRandomizer(resultClass, fieldType, fieldName) ? this.randomizers.get(new RandomizerDefinition(resultClass, fieldType, fieldName)).getRandomValue() : (this.isSupportedType(fieldType) ? this.populateSupportedType(field, fieldType) : this.populateBean(fieldType, new String[0]));
        if (object != null) {
            PropertyUtils.setProperty((Object)result, (String)fieldName, (Object)object);
        }
    }

    private Object populateSupportedType(Field field, Class<?> fieldType) {
        Object object = this.isBeanValidationAnnotationPresent(field) ? BeanValidationRandomizer.getRandomValue(field) : DefaultRandomizer.getRandomValue(fieldType);
        return object;
    }

    private void populateCollectionType(Object result, Field field) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> fieldType = field.getType();
        String fieldName = field.getName();
        if (this.customRandomizer(result.getClass(), fieldType, fieldName)) {
            this.populateSimpleType(result, field);
        } else {
            if (fieldType.isArray()) {
                PropertyUtils.setProperty((Object)result, (String)fieldName, (Object)Array.newInstance(fieldType.getComponentType(), 0));
                return;
            }
            Object collection = null;
            if (List.class.isAssignableFrom(fieldType)) {
                collection = Collections.emptyList();
            } else if (NavigableSet.class.isAssignableFrom(fieldType)) {
                collection = new TreeSet();
            } else if (SortedSet.class.isAssignableFrom(fieldType)) {
                collection = new TreeSet();
            } else if (Set.class.isAssignableFrom(fieldType)) {
                collection = Collections.emptySet();
            } else if (Deque.class.isAssignableFrom(fieldType)) {
                collection = new ArrayDeque();
            } else if (Queue.class.isAssignableFrom(fieldType)) {
                collection = new ArrayDeque();
            } else if (NavigableMap.class.isAssignableFrom(fieldType)) {
                collection = new TreeMap();
            } else if (SortedMap.class.isAssignableFrom(fieldType)) {
                collection = new TreeMap();
            } else if (Map.class.isAssignableFrom(fieldType)) {
                collection = Collections.emptyMap();
            } else if (Collection.class.isAssignableFrom(fieldType)) {
                collection = Collections.emptyList();
            }
            PropertyUtils.setProperty((Object)result, (String)fieldName, collection);
        }
    }

    private boolean isSupportedType(Class<?> type) {
        return this.supportedTypesList.contains(type);
    }

    private boolean isCollectionType(Class<?> type) {
        return type.isArray() || Map.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type);
    }

    private boolean customRandomizer(Class<?> type, Class<?> fieldType, String fieldName) {
        return this.randomizers.get(new RandomizerDefinition(type, fieldType, fieldName)) != null;
    }

    public void setRandomizers(Map<RandomizerDefinition, Randomizer> randomizers) {
        this.randomizers = randomizers;
    }

    private boolean shouldExcludeField(Field field, String ... excludedFields) {
        if (field.isAnnotationPresent(Exclude.class)) {
            return true;
        }
        if (excludedFields == null || excludedFields.length == 0) {
            return false;
        }
        String fieldName = field.getName().toLowerCase();
        for (String excludedFieldName : excludedFields) {
            if (!fieldName.equalsIgnoreCase(excludedFieldName)) continue;
            return true;
        }
        return false;
    }

    private boolean isBeanValidationAnnotationPresent(Field field) {
        return field.isAnnotationPresent(AssertFalse.class) || field.isAnnotationPresent(AssertTrue.class) || field.isAnnotationPresent(Null.class) || field.isAnnotationPresent(Future.class) || field.isAnnotationPresent(Past.class) || field.isAnnotationPresent(Max.class) || field.isAnnotationPresent(Min.class) || field.isAnnotationPresent(DecimalMax.class) || field.isAnnotationPresent(DecimalMin.class) || field.isAnnotationPresent(Size.class);
    }

    private boolean isStaticOrFinal(Field field) {
        int fieldModifiers = field.getModifiers();
        return Modifier.isStatic(fieldModifiers) || Modifier.isFinal(fieldModifiers);
    }
}

