package io.github.baharmc.chat

import org.hjson.JsonObject

class ClickEvent(val action: ClickAction, val value: String) {

    companion object {

        fun of(action: ClickAction?, text: String?): ClickEvent? {
            return ClickEvent(action!!, text!!)
        }

        fun fromJson(json: JsonObject): ClickEvent? {
            return of(ClickAction.valueOf(json.get("action").asString().toUpperCase()), json.get("value").asString())
        }

    }

    fun asJson(): JsonObject {
        val obj = JsonObject()
        obj.add("action", action.name.toLowerCase())
        obj.add("value", value)
        return obj
    }

}