/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.yaml;

import io.github.azagniotov.stubby4j.utils.StringUtils;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum ConfigurableYAMLProperty {
    BODY,
    FILE,
    HEADERS,
    HTTPLIFECYCLE,
    LATENCY,
    METHOD,
    POST,
    QUERY,
    REQUEST,
    RESPONSE,
    STATUS,
    URL;

    private static final Map<String, ConfigurableYAMLProperty> CACHE;

    public static boolean isUnknownProperty(String stubbedProperty) {
        return !CACHE.containsKey(StringUtils.toLower(stubbedProperty));
    }

    public static Optional<ConfigurableYAMLProperty> ofNullableProperty(String stubbedProperty) {
        return Optional.ofNullable(CACHE.get(StringUtils.toLower(stubbedProperty)));
    }

    public String toString() {
        return StringUtils.toLower(this.name());
    }

    static {
        CACHE = new HashMap<String, ConfigurableYAMLProperty>();
        for (ConfigurableYAMLProperty enumMember : EnumSet.allOf(ConfigurableYAMLProperty.class)) {
            CACHE.put(enumMember.toString(), enumMember);
        }
    }
}

