/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.stubs;

import io.github.azagniotov.generics.TypeSafeConverter;
import io.github.azagniotov.stubby4j.annotations.CoberturaIgnore;
import io.github.azagniotov.stubby4j.annotations.VisibleForTesting;
import io.github.azagniotov.stubby4j.stubs.AbstractBuilder;
import io.github.azagniotov.stubby4j.stubs.ReflectableStub;
import io.github.azagniotov.stubby4j.stubs.RegexParser;
import io.github.azagniotov.stubby4j.stubs.StubMatcher;
import io.github.azagniotov.stubby4j.stubs.StubbableAuthorizationType;
import io.github.azagniotov.stubby4j.utils.CollectionUtils;
import io.github.azagniotov.stubby4j.utils.FileUtils;
import io.github.azagniotov.stubby4j.utils.ObjectUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import io.github.azagniotov.stubby4j.yaml.ConfigurableYAMLProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpMethod;

public class StubRequest
implements ReflectableStub {
    static final String HTTP_HEADER_AUTHORIZATION = "authorization";
    private final String url;
    private final String post;
    private final File file;
    private final byte[] fileBytes;
    private final List<String> method;
    private final Map<String, String> headers;
    private final Map<String, String> query;
    private final Map<String, String> regexGroups;

    private StubRequest(String url, String post, File file, List<String> method, Map<String, String> headers, Map<String, String> query) {
        this.url = url;
        this.post = post;
        this.file = file;
        this.fileBytes = ObjectUtils.isNull(file) ? new byte[]{} : this.getFileBytes();
        this.method = method;
        this.headers = headers;
        this.query = query;
        this.regexGroups = new TreeMap<String, String>();
    }

    public final ArrayList<String> getMethod() {
        return this.method.stream().map(StringUtils::toUpper).collect(Collectors.toCollection(ArrayList::new));
    }

    public String getUri() {
        return this.url;
    }

    public String getUrl() {
        if (this.getQuery().isEmpty()) {
            return this.url;
        }
        String queryString = CollectionUtils.constructQueryString(this.query);
        return String.format("%s?%s", this.url, queryString);
    }

    private byte[] getFileBytes() {
        try {
            return FileUtils.fileToBytes(this.file);
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public String getPostBody() {
        if (this.fileBytes.length == 0) {
            return FileUtils.enforceSystemLineSeparator(this.post);
        }
        String utf8FileContent = StringUtils.newStringUtf8(this.fileBytes);
        return FileUtils.enforceSystemLineSeparator(utf8FileContent);
    }

    public String getPost() {
        return this.post;
    }

    public final Map<String, String> getHeaders() {
        LinkedHashMap<String, String> headersCopy = new LinkedHashMap<String, String>(this.headers);
        Set entrySet = headersCopy.entrySet();
        this.headers.clear();
        for (Map.Entry entry : entrySet) {
            this.headers.put(StringUtils.toLower((String)entry.getKey()), (String)entry.getValue());
        }
        return this.headers;
    }

    public Map<String, String> getQuery() {
        return this.query;
    }

    public byte[] getFile() {
        return this.fileBytes;
    }

    public Map<String, String> getRegexGroups() {
        return new TreeMap<String, String>(this.regexGroups);
    }

    public File getRawFile() {
        return this.file;
    }

    public boolean hasHeaders() {
        return !this.getHeaders().isEmpty();
    }

    public boolean hasQuery() {
        return !this.getQuery().isEmpty();
    }

    public boolean hasPostBody() {
        return StringUtils.isSet(this.getPostBody());
    }

    boolean isSecured() {
        return this.getHeaders().containsKey(StubbableAuthorizationType.BASIC.asYAMLProp()) || this.getHeaders().containsKey(StubbableAuthorizationType.BEARER.asYAMLProp()) || this.getHeaders().containsKey(StubbableAuthorizationType.CUSTOM.asYAMLProp());
    }

    @VisibleForTesting
    StubbableAuthorizationType getStubbedAuthorizationType() {
        if (this.getHeaders().containsKey(StubbableAuthorizationType.BASIC.asYAMLProp())) {
            return StubbableAuthorizationType.BASIC;
        }
        if (this.getHeaders().containsKey(StubbableAuthorizationType.BEARER.asYAMLProp())) {
            return StubbableAuthorizationType.BEARER;
        }
        return StubbableAuthorizationType.CUSTOM;
    }

    String getStubbedHeaderAuthorization(StubbableAuthorizationType stubbableAuthorizationType) {
        return this.getHeaders().get(stubbableAuthorizationType.asYAMLProp());
    }

    public String getRawHeaderAuthorization() {
        return this.getHeaders().get(HTTP_HEADER_AUTHORIZATION);
    }

    @VisibleForTesting
    boolean isPostStubbed() {
        return StringUtils.isSet(this.getPostBody()) && (this.getMethod().contains("POST") || this.getMethod().contains("PUT"));
    }

    public void compileRegexPatternsAndCache() {
        if (StringUtils.isSet(this.url)) {
            RegexParser.INSTANCE.compilePatternAndCache(this.url);
        }
        if (this.isPostStubbed()) {
            RegexParser.INSTANCE.compilePatternAndCache(this.getPostBody());
        }
        this.getQuery().values().forEach(RegexParser.INSTANCE::compilePatternAndCache);
        this.getHeaders().values().forEach(RegexParser.INSTANCE::compilePatternAndCache);
    }

    public boolean equals(Object that) {
        StubRequest stubbedRequest;
        if (this == that) {
            return true;
        }
        return that instanceof StubRequest && new StubMatcher(this.regexGroups).matches(stubbedRequest = (StubRequest)that, this);
    }

    @CoberturaIgnore
    public int hashCode() {
        int result = ObjectUtils.isNotNull(this.url) ? this.url.hashCode() : 0;
        result = 31 * result + this.method.hashCode();
        result = 31 * result + (ObjectUtils.isNotNull(this.post) ? this.post.hashCode() : 0);
        result = 31 * result + (ObjectUtils.isNotNull(this.fileBytes) && this.fileBytes.length != 0 ? Arrays.hashCode(this.fileBytes) : 0);
        result = 31 * result + this.headers.hashCode();
        result = 31 * result + this.query.hashCode();
        return result;
    }

    @CoberturaIgnore
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StubRequest");
        sb.append("{url=").append(this.url);
        sb.append(", method=").append(this.method);
        if (!ObjectUtils.isNull(this.post)) {
            sb.append(", post=").append(this.post);
        }
        sb.append(", query=").append(this.query);
        sb.append(", headers=").append(this.getHeaders());
        sb.append('}');
        return sb.toString();
    }

    public static final class Builder
    extends AbstractBuilder<StubRequest> {
        private String url = null;
        private List<String> method = new ArrayList<String>();
        private String post = null;
        private File file = null;
        private Map<String, String> headers = new LinkedHashMap<String, String>();
        private Map<String, String> query = new LinkedHashMap<String, String>();

        public Builder withMethod(String value) {
            if (StringUtils.isSet(value)) {
                this.method.add(value);
            }
            return this;
        }

        public Builder withMethodGet() {
            this.method.add(HttpMethod.GET.asString());
            return this;
        }

        public Builder withMethodPut() {
            this.method.add(HttpMethod.PUT.asString());
            return this;
        }

        public Builder withMethodPost() {
            this.method.add(HttpMethod.POST.asString());
            return this;
        }

        public Builder withMethodHead() {
            this.method.add(HttpMethod.HEAD.asString());
            return this;
        }

        public Builder withUrl(String value) {
            this.url = value;
            return this;
        }

        public Builder withHeader(String key, String value) {
            this.headers.put(String.valueOf(key), String.valueOf(value));
            return this;
        }

        public Builder withHeaderContentType(String value) {
            this.headers.put("content-type", value);
            return this;
        }

        public Builder withApplicationJsonContentType() {
            this.headers.put("content-type", "application/json");
            return this;
        }

        public Builder withApplicationXmlContentType() {
            this.headers.put("content-type", "application/xml");
            return this;
        }

        public Builder withHeaderContentLength(String value) {
            this.headers.put("content-length", value);
            return this;
        }

        public Builder withHeaderContentLanguage(String value) {
            this.headers.put("content-language", value);
            return this;
        }

        public Builder withHeaderContentEncoding(String value) {
            this.headers.put("content-encoding", value);
            return this;
        }

        public Builder withHeaderPragma(String value) {
            this.headers.put("pragma", value);
            return this;
        }

        public Builder withYAMLHeaderAuthorizationBasic(String value) {
            this.headers.put(StubbableAuthorizationType.BASIC.asYAMLProp(), value);
            return this;
        }

        public Builder withYAMLHeaderAuthorizationBearer(String value) {
            this.headers.put(StubbableAuthorizationType.BEARER.asYAMLProp(), value);
            return this;
        }

        public Builder withPost(String post) {
            this.post = post;
            return this;
        }

        public Builder withFile(File file) {
            this.file = file;
            return this;
        }

        public Builder withQuery(String key, String value) {
            this.query.put(key, value);
            return this;
        }

        public Builder withQuery(Map<String, String> query) {
            this.query.putAll(query);
            return this;
        }

        @Override
        public StubRequest build() {
            this.url = this.getStaged(String.class, ConfigurableYAMLProperty.URL, this.url);
            this.post = this.getStaged(String.class, ConfigurableYAMLProperty.POST, this.post);
            this.file = this.getStaged(File.class, ConfigurableYAMLProperty.FILE, this.file);
            this.method = TypeSafeConverter.asCheckedArrayList(this.getStaged(List.class, ConfigurableYAMLProperty.METHOD, this.method), String.class);
            this.headers = TypeSafeConverter.asCheckedLinkedHashMap(this.getStaged(Map.class, ConfigurableYAMLProperty.HEADERS, this.headers), String.class, String.class);
            this.query = TypeSafeConverter.asCheckedLinkedHashMap(this.getStaged(Map.class, ConfigurableYAMLProperty.QUERY, this.query), String.class, String.class);
            StubRequest stubRequest = new StubRequest(this.url, this.post, this.file, this.method, this.headers, this.query);
            this.url = null;
            this.method = new ArrayList<String>();
            this.post = null;
            this.file = null;
            this.headers = new LinkedHashMap<String, String>();
            this.query = new LinkedHashMap<String, String>();
            this.fieldNameAndValues.clear();
            return stubRequest;
        }
    }
}

