/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers.strategy.stubs;

import io.github.azagniotov.stubby4j.annotations.VisibleForTesting;
import io.github.azagniotov.stubby4j.handlers.strategy.stubs.StubResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.stubs.StubRequest;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import javax.servlet.http.HttpServletResponse;

public final class UnauthorizedResponseHandlingStrategy
implements StubResponseHandlingStrategy {
    @VisibleForTesting
    public static final String NO_AUTHORIZATION_HEADER = "You are not authorized to view this page without supplied 'Authorization' HTTP header";
    @VisibleForTesting
    public static final String WRONG_AUTHORIZATION_HEADER_TEMPLATE = "Unauthorized with supplied 'authorized' header value: '%s'";

    UnauthorizedResponseHandlingStrategy() {
    }

    @Override
    public void handle(HttpServletResponse response, StubRequest assertionStubRequest) throws Exception {
        HandlerUtils.setResponseMainHeaders(response);
        String authorizationHeader = assertionStubRequest.getRawHeaderAuthorization();
        if (!StringUtils.isSet(authorizationHeader)) {
            HandlerUtils.configureErrorResponse(response, 401, NO_AUTHORIZATION_HEADER);
            return;
        }
        HandlerUtils.configureErrorResponse(response, 401, String.format(WRONG_AUTHORIZATION_HEADER_TEMPLATE, authorizationHeader));
    }
}

