/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers.strategy.stubs;

import io.github.azagniotov.stubby4j.handlers.strategy.stubs.DefaultResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.handlers.strategy.stubs.NotFoundResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.handlers.strategy.stubs.RedirectResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.handlers.strategy.stubs.StubResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.handlers.strategy.stubs.UnauthorizedResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.stubs.StubResponse;
import org.eclipse.jetty.http.HttpStatus;

public final class StubsResponseHandlingStrategyFactory {
    private StubsResponseHandlingStrategyFactory() {
    }

    public static StubResponseHandlingStrategy getStrategy(StubResponse foundStubResponse) {
        HttpStatus.Code httpStatusCode = foundStubResponse.getHttpStatusCode();
        switch (httpStatusCode) {
            case NOT_FOUND: {
                return new NotFoundResponseHandlingStrategy();
            }
            case UNAUTHORIZED: {
                return new UnauthorizedResponseHandlingStrategy();
            }
            case MOVED_PERMANENTLY: 
            case FOUND: 
            case MOVED_TEMPORARILY: 
            case SEE_OTHER: 
            case TEMPORARY_REDIRECT: 
            case PERMANET_REDIRECT: {
                return new RedirectResponseHandlingStrategy(foundStubResponse);
            }
        }
        return new DefaultResponseHandlingStrategy(foundStubResponse);
    }
}

