/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers.strategy.stubs;

import io.github.azagniotov.stubby4j.handlers.strategy.stubs.StubResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.stubs.StubRequest;
import io.github.azagniotov.stubby4j.stubs.StubResponse;
import io.github.azagniotov.stubby4j.utils.FileUtils;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public final class DefaultResponseHandlingStrategy
implements StubResponseHandlingStrategy {
    private final StubResponse stubbedResponse;

    DefaultResponseHandlingStrategy(StubResponse stubbedResponse) {
        this.stubbedResponse = stubbedResponse;
    }

    @Override
    public void handle(HttpServletResponse response, StubRequest assertionStubRequest) throws Exception {
        Map<String, String> regexGroups = assertionStubRequest.getRegexGroups();
        HandlerUtils.setResponseMainHeaders(response);
        this.setResponseStubbedHeaders(response, this.stubbedResponse, regexGroups);
        if (StringUtils.isSet(this.stubbedResponse.getLatency())) {
            long latency = Long.parseLong(this.stubbedResponse.getLatency());
            TimeUnit.MILLISECONDS.sleep(latency);
        }
        response.setStatus(this.stubbedResponse.getHttpStatusCode().getCode());
        byte[] responseBody = this.stubbedResponse.getResponseBodyAsBytes();
        if (this.stubbedResponse.isFilePathContainsTemplateTokens()) {
            String resolvedPath = StringUtils.replaceTokensInString(this.stubbedResponse.getRawFileAbsolutePath(), regexGroups);
            File resolvedFile = new File(resolvedPath);
            if (resolvedFile.exists()) {
                this.writeOutputStream(response, FileUtils.fileToBytes(resolvedFile));
            } else {
                response.setStatus(404);
            }
        } else if (this.stubbedResponse.isBodyContainsTemplateTokens()) {
            this.writeOutputStream(response, StringUtils.getBytesUtf8(StringUtils.replaceTokens(responseBody, regexGroups)));
        } else {
            this.writeOutputStream(response, responseBody);
        }
    }

    private void setResponseStubbedHeaders(HttpServletResponse response, StubResponse stubResponse, Map<String, String> regexGroups) {
        for (Map.Entry<String, String> headerPair : stubResponse.getHeaders().entrySet()) {
            String responseHeaderValue = headerPair.getValue();
            if (StringUtils.isTokenized(responseHeaderValue)) {
                responseHeaderValue = StringUtils.replaceTokensInString(headerPair.getValue(), regexGroups);
            }
            response.setHeader(headerPair.getKey(), responseHeaderValue);
        }
    }

    private void writeOutputStream(HttpServletResponse response, byte[] responseBody) throws IOException {
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(responseBody);
            outputStream.flush();
        }
    }
}

