/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers.strategy.admin;

import io.github.azagniotov.stubby4j.handlers.strategy.admin.AdminResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.stubs.StubRepository;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetHandlingStrategy
implements AdminResponseHandlingStrategy {
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, StubRepository stubRepository) throws IOException {
        StringBuilder yamlAppender = new StringBuilder();
        int contextPathLength = "/".length();
        String pathInfoNoHeadingSlash = request.getRequestURI().substring(contextPathLength);
        if (StringUtils.isSet(pathInfoNoHeadingSlash)) {
            int targetHttpStubCycleIndex = Integer.parseInt(pathInfoNoHeadingSlash);
            if (!stubRepository.canMatchStubByIndex(targetHttpStubCycleIndex)) {
                String errorMessage = String.format("Stub request index#%s does not exist, cannot display", targetHttpStubCycleIndex);
                HandlerUtils.configureErrorResponse(response, 204, errorMessage);
                return;
            }
            yamlAppender.append(stubRepository.getStubYAMLByIndex(targetHttpStubCycleIndex));
        } else {
            yamlAppender.append(stubRepository.getStubYAML());
        }
        response.setContentType("text/plain;charset=UTF-8");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(StringUtils.getBytesUtf8(yamlAppender.toString()));
            outputStream.flush();
        }
    }
}

