/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers;

import io.github.azagniotov.stubby4j.cli.ANSITerminal;
import io.github.azagniotov.stubby4j.server.JettyContext;
import io.github.azagniotov.stubby4j.stubs.StubRepository;
import io.github.azagniotov.stubby4j.utils.ConsoleUtils;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import io.github.azagniotov.stubby4j.yaml.YAMLParser;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public final class StubDataRefreshActionHandler
extends AbstractHandler {
    private final StubRepository stubRepository;
    private final JettyContext jettyContext;

    public StubDataRefreshActionHandler(JettyContext newContext, StubRepository newStubRepository) {
        this.jettyContext = newContext;
        this.stubRepository = newStubRepository;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConsoleUtils.logIncomingRequest(request);
        if (response.isCommitted() || baseRequest.isHandled()) {
            ConsoleUtils.logIncomingRequestError(request, "stubData", "HTTP response was committed or base request was handled, aborting..");
            return;
        }
        baseRequest.setHandled(true);
        response.setContentType("text/plain;charset=UTF-8");
        response.setStatus(200);
        response.setHeader(HttpHeader.SERVER.asString(), HandlerUtils.constructHeaderServerName());
        try {
            this.stubRepository.refreshStubsFromYAMLConfig(new YAMLParser());
            String successMessage = String.format("Successfully performed live refresh of main YAML from: %s on [" + new Date().toString().trim() + "]", this.stubRepository.getYAMLConfig());
            response.getWriter().println(successMessage);
            ANSITerminal.ok(successMessage);
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(response, 500, ex.toString());
        }
        ConsoleUtils.logOutgoingResponse(request.getRequestURI(), response);
    }
}

