/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers;

import io.github.azagniotov.stubby4j.annotations.VisibleForTesting;
import io.github.azagniotov.stubby4j.stubs.StubHttpLifecycle;
import io.github.azagniotov.stubby4j.stubs.StubRepository;
import io.github.azagniotov.stubby4j.stubs.StubTypes;
import io.github.azagniotov.stubby4j.utils.ConsoleUtils;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class AjaxResourceContentHandler
extends AbstractHandler {
    private static final Pattern REGEX_REQUEST = Pattern.compile("^(request)$");
    private static final Pattern REGEX_RESPONSE = Pattern.compile("^(response)$");
    private static final Pattern REGEX_HTTPLIFECYCLE = Pattern.compile("^(httplifecycle)$");
    private static final Pattern REGEX_NUMERIC = Pattern.compile("^[0-9]+$");
    private final StubRepository stubRepository;

    public AjaxResourceContentHandler(StubRepository stubRepository) {
        this.stubRepository = stubRepository;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConsoleUtils.logIncomingRequest(request);
        if (response.isCommitted() || baseRequest.isHandled()) {
            ConsoleUtils.logIncomingRequestError(request, "ajaxResource", "HTTP response was committed or base request was handled, aborting..");
            return;
        }
        baseRequest.setHandled(true);
        HandlerUtils.setResponseMainHeaders(response);
        response.setContentType("text/plain;charset=UTF-8");
        response.setStatus(200);
        String[] uriFragments = request.getRequestURI().split("/");
        int urlFragmentsLength = uriFragments.length;
        String targetFieldName = uriFragments[urlFragmentsLength - 1];
        String stubType = uriFragments[urlFragmentsLength - 2];
        if (REGEX_NUMERIC.matcher(stubType).matches()) {
            int sequencedResponseId = Integer.parseInt(stubType);
            int resourceIndex = Integer.parseInt(uriFragments[urlFragmentsLength - 4]);
            StubHttpLifecycle foundStub = this.throwErrorOnNonExistentResourceIndex(response, resourceIndex);
            this.renderAjaxResponseContent(response, sequencedResponseId, targetFieldName, foundStub);
        } else {
            int resourceIndex = Integer.parseInt(uriFragments[urlFragmentsLength - 3]);
            StubHttpLifecycle foundStub = this.throwErrorOnNonExistentResourceIndex(response, resourceIndex);
            if (REGEX_REQUEST.matcher(stubType).matches()) {
                this.renderAjaxResponseContent(response, StubTypes.REQUEST, targetFieldName, foundStub);
            } else if (REGEX_RESPONSE.matcher(stubType).matches()) {
                this.renderAjaxResponseContent(response, StubTypes.RESPONSE, targetFieldName, foundStub);
            } else if (REGEX_HTTPLIFECYCLE.matcher(stubType).matches()) {
                this.renderAjaxResponseContent(response, StubTypes.HTTPLIFECYCLE, targetFieldName, foundStub);
            } else {
                response.getWriter().println(String.format("Could not fetch the content for stub type: %s", stubType));
            }
        }
        ConsoleUtils.logOutgoingResponse(request.getRequestURI(), response);
    }

    @VisibleForTesting
    void renderAjaxResponseContent(HttpServletResponse response, StubTypes stubType, String targetFieldName, StubHttpLifecycle foundStub) throws IOException {
        try {
            String ajaxResponse = foundStub.getAjaxResponseContent(stubType, targetFieldName);
            String popupHtmlTemplate = HandlerUtils.getHtmlResourceByName("_popup_generic");
            String htmlPopup = String.format(popupHtmlTemplate, foundStub.getResourceId(), targetFieldName, ajaxResponse);
            response.getWriter().println(htmlPopup);
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(response, 500, ex.toString());
        }
    }

    @VisibleForTesting
    void renderAjaxResponseContent(HttpServletResponse response, int sequencedResponseId, String targetFieldName, StubHttpLifecycle foundStub) throws IOException {
        try {
            String ajaxResponse = foundStub.getAjaxResponseContent(targetFieldName, sequencedResponseId);
            String popupHtmlTemplate = HandlerUtils.getHtmlResourceByName("_popup_generic");
            String htmlPopup = String.format(popupHtmlTemplate, foundStub.getResourceId(), targetFieldName, ajaxResponse);
            response.getWriter().println(htmlPopup);
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(response, 500, ex.toString());
        }
    }

    @VisibleForTesting
    StubHttpLifecycle throwErrorOnNonExistentResourceIndex(HttpServletResponse response, int resourceIndex) throws IOException {
        Optional<StubHttpLifecycle> foundStubOptional = this.stubRepository.matchStubByIndex(resourceIndex);
        if (!foundStubOptional.isPresent()) {
            String error = "Resource does not exist for ID: " + resourceIndex;
            response.getWriter().println(error);
            throw new IOException(error);
        }
        return foundStubOptional.get();
    }
}

