/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers;

import io.github.azagniotov.stubby4j.stubs.StubRepository;
import io.github.azagniotov.stubby4j.utils.ConsoleUtils;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class AjaxEndpointStatsHandler
extends AbstractHandler {
    private final StubRepository stubRepository;

    public AjaxEndpointStatsHandler(StubRepository stubRepository) {
        this.stubRepository = stubRepository;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted() || baseRequest.isHandled()) {
            ConsoleUtils.logIncomingRequestError(request, "ajaxEndpoint", "HTTP response was committed or base request was handled, aborting..");
            return;
        }
        baseRequest.setHandled(true);
        HandlerUtils.setResponseMainHeaders(response);
        response.setContentType("text/plain;charset=UTF-8");
        response.setStatus(200);
        try {
            if (request.getRequestURI().contains("stats/check")) {
                response.getWriter().println(!this.stubRepository.getResourceStats().isEmpty());
            } else {
                ConsoleUtils.logIncomingRequest(request);
                String popupStatsHtmlTemplate = HandlerUtils.getHtmlResourceByName("_popup_stats");
                String htmlPopup = String.format(popupStatsHtmlTemplate, this.stubRepository.getResourceStatsAsCsv());
                response.getWriter().println(htmlPopup);
                ConsoleUtils.logOutgoingResponse(request.getRequestURI(), response);
            }
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(response, 500, ex.toString());
        }
    }
}

