/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers;

import io.github.azagniotov.stubby4j.handlers.strategy.admin.AdminResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.handlers.strategy.admin.AdminResponseHandlingStrategyFactory;
import io.github.azagniotov.stubby4j.stubs.StubRepository;
import io.github.azagniotov.stubby4j.utils.ConsoleUtils;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class AdminPortalHandler
extends AbstractHandler {
    public static final String NAME = "admin";
    public static final String ADMIN_ROOT = "/";
    private final StubRepository stubRepository;

    public AdminPortalHandler(StubRepository stubRepository) {
        this.stubRepository = stubRepository;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConsoleUtils.logIncomingRequest(request);
        if (response.isCommitted() || baseRequest.isHandled()) {
            ConsoleUtils.logIncomingRequestError(request, NAME, "HTTP response was committed or base request was handled, aborting..");
            return;
        }
        baseRequest.setHandled(true);
        HandlerUtils.setResponseMainHeaders(response);
        response.setStatus(200);
        AdminResponseHandlingStrategy strategyStubResponse = AdminResponseHandlingStrategyFactory.getStrategy(request);
        try {
            strategyStubResponse.handle(request, response, this.stubRepository);
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(response, 500, "Problem handling request in Admin handler: " + ex.toString());
        }
        ConsoleUtils.logOutgoingResponse(request.getRequestURI(), response);
    }
}

