/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j;

import io.github.azagniotov.stubby4j.cli.ANSITerminal;
import io.github.azagniotov.stubby4j.cli.CommandLineInterpreter;
import io.github.azagniotov.stubby4j.server.StubbyManager;
import io.github.azagniotov.stubby4j.server.StubbyManagerFactory;
import io.github.azagniotov.stubby4j.stubs.StubHttpLifecycle;
import io.github.azagniotov.stubby4j.utils.ConsoleUtils;
import io.github.azagniotov.stubby4j.utils.FileUtils;
import io.github.azagniotov.stubby4j.yaml.YAMLParser;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.cli.ParseException;

public final class Main {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(1);
    private static CommandLineInterpreter commandLineInterpreter;

    private Main() {
    }

    public static void main(String[] args) {
        commandLineInterpreter = new CommandLineInterpreter();
        Main.parseCommandLineArgs(args);
        if (Main.printHelpIfRequested() || Main.printVersionIfRequested()) {
            return;
        }
        Main.verifyYamlDataProvided();
        Main.startStubby4jUsingCommandLineArgs();
    }

    private static void parseCommandLineArgs(String[] args) {
        try {
            commandLineInterpreter.parseCommandLine(args);
        }
        catch (ParseException ex) {
            String msg = String.format("Could not parse provided command line arguments, error: %s", ex.toString());
            throw new IllegalArgumentException(msg);
        }
    }

    private static boolean printHelpIfRequested() {
        if (!commandLineInterpreter.isHelp()) {
            return false;
        }
        commandLineInterpreter.printHelp();
        return true;
    }

    private static boolean printVersionIfRequested() {
        if (!commandLineInterpreter.isVersion()) {
            return false;
        }
        commandLineInterpreter.printVersion();
        return true;
    }

    private static void verifyYamlDataProvided() {
        if (commandLineInterpreter.isYamlProvided()) {
            return;
        }
        String msg = String.format("YAML data was not provided using command line option '--%s'. %sTo see all command line options run again with option '--%s'", "data", FileUtils.BR, "help");
        throw new IllegalArgumentException(msg);
    }

    private static void startStubby4jUsingCommandLineArgs() {
        try {
            long initialStart = System.currentTimeMillis();
            Map<String, String> commandLineArgs = commandLineInterpreter.getCommandlineParams();
            String configFilename = commandLineArgs.get("data");
            ANSITerminal.muteConsole(commandLineInterpreter.isMute());
            ConsoleUtils.enableDebug(commandLineInterpreter.isDebug());
            File configFile = new File(configFilename);
            Future<List<StubHttpLifecycle>> stubLoadComputation = EXECUTOR_SERVICE.submit(() -> new YAMLParser().parse(configFile.getParent(), configFile));
            StubbyManager stubbyManager = new StubbyManagerFactory().construct(configFile, commandLineArgs, stubLoadComputation);
            stubbyManager.startJetty();
            long totalEnd = System.currentTimeMillis();
            ANSITerminal.status(String.format(FileUtils.BR + "stubby4j successfully started after %s milliseconds", totalEnd - initialStart) + FileUtils.BR);
            stubbyManager.statuses().forEach(ANSITerminal::status);
            ANSITerminal.info(FileUtils.BR + "Quit: ctrl-c" + FileUtils.BR);
        }
        catch (Exception ex) {
            String msg = String.format("Could not init stubby4j, error: %s", ex.toString());
            throw new IllegalStateException(msg, ex);
        }
    }
}

