/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.matcher;

public class AntPathMatcherArrays {
    private static final char ASTERISK = '*';
    private static final char QUESTION = '?';
    private static final char BLANK = ' ';
    private static final int ASCII_CASE_DIFFERENCE_VALUE = 32;
    private final char pathSeparator;
    private final boolean ignoreCase;
    private final boolean matchStart;
    private final boolean trimTokens;

    private AntPathMatcherArrays(char pathSeparator, boolean ignoreCase, boolean matchStart, boolean trimTokens) {
        this.pathSeparator = pathSeparator;
        this.ignoreCase = ignoreCase;
        this.matchStart = matchStart;
        this.trimTokens = trimTokens;
    }

    public boolean isMatch(String pattern, String path) {
        return this.isMatch(pattern.toCharArray(), 0, path.toCharArray(), 0);
    }

    private boolean isMatch(char[] pattern, int patternPointer, char[] path, int pathPointer) {
        if (this.empty(pattern, patternPointer)) {
            return this.empty(path, pathPointer);
        }
        if (this.empty(path, pathPointer) && pattern[patternPointer] == this.pathSeparator) {
            if (this.matchStart) {
                return true;
            }
            if (this.lengthOf(pattern, 2, patternPointer) && pattern[patternPointer + 1] == '*') {
                return false;
            }
            return this.isMatch(pattern, patternPointer + 1, path, pathPointer);
        }
        char patternStart = pattern[patternPointer];
        if (patternStart == '*') {
            int start;
            if (this.lengthOf(pattern, 1, patternPointer)) {
                return this.empty(path, pathPointer) || path[pathPointer] != this.pathSeparator && this.isMatch(pattern, patternPointer, path, pathPointer + 1);
            }
            if (this.doubleAsteriskMatch(pattern, patternPointer, path, pathPointer)) {
                return true;
            }
            for (start = pathPointer; start < path.length; ++start) {
                if (!this.isMatch(pattern, patternPointer + 1, path, start)) continue;
                return true;
            }
            return this.isMatch(pattern, patternPointer + 1, path, start);
        }
        int pointer = this.skipBlanks(path, pathPointer);
        return pointer < path.length && (this.equal(path[pointer], patternStart) || patternStart == '?') && this.isMatch(pattern, patternPointer + 1, path, pointer + 1);
    }

    private boolean doubleAsteriskMatch(char[] pattern, int patternPointer, char[] path, int pathPointer) {
        if (pattern[patternPointer + 1] != '*') {
            return false;
        }
        if (pattern.length - patternPointer > 2) {
            return this.isMatch(pattern, patternPointer + 3, path, pathPointer);
        }
        return false;
    }

    private int skipBlanks(char[] path, int pathPointer) {
        int pointer;
        if (this.trimTokens) {
            for (pointer = pathPointer; pointer < path.length && path[pointer] == ' '; ++pointer) {
            }
        }
        return pointer;
    }

    private boolean equal(char pathChar, char patternChar) {
        if (this.ignoreCase) {
            return pathChar == patternChar || (pathChar > patternChar ? pathChar == patternChar + 32 : pathChar == patternChar - 32);
        }
        return pathChar == patternChar;
    }

    private boolean empty(char[] characters, int pointer) {
        return characters.length == pointer;
    }

    private boolean lengthOf(char[] characters, int length, int pointer) {
        return characters.length - pointer == length;
    }

    public static final class Builder {
        private char pathSeparator = (char)47;
        private boolean ignoreCase = false;
        private boolean matchStart = false;
        private boolean trimTokens = false;

        public Builder withPathSeparator(char pathSeparator) {
            this.pathSeparator = pathSeparator;
            return this;
        }

        public Builder withIgnoreCase() {
            this.ignoreCase = true;
            return this;
        }

        public Builder withMatchStart() {
            this.matchStart = true;
            return this;
        }

        public Builder withTrimTokens() {
            this.trimTokens = true;
            return this;
        }

        public AntPathMatcherArrays build() {
            return new AntPathMatcherArrays(this.pathSeparator, this.ignoreCase, this.matchStart, this.trimTokens);
        }
    }
}

