/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.matcher;

public class AntPathMatcher {
    private static final char ASTERISK = '*';
    private static final char QUESTION = '?';
    private static final char BLANK = ' ';
    private static final int ASCII_CASE_DIFFERENCE_VALUE = 32;
    private final char pathSeparator;
    private final boolean ignoreCase;
    private final boolean matchStart;
    private final boolean trimTokens;

    private AntPathMatcher(char pathSeparator, boolean ignoreCase, boolean matchStart, boolean trimTokens) {
        this.pathSeparator = pathSeparator;
        this.ignoreCase = ignoreCase;
        this.matchStart = matchStart;
        this.trimTokens = trimTokens;
    }

    public boolean isMatch(String pattern, String path) {
        if (pattern.isEmpty()) {
            return path.isEmpty();
        }
        if (path.isEmpty() && pattern.charAt(0) == this.pathSeparator) {
            if (this.matchStart) {
                return true;
            }
            if (pattern.length() == 2 && pattern.charAt(1) == '*') {
                return false;
            }
            return this.isMatch(pattern.substring(1), path);
        }
        char patternStart = pattern.charAt(0);
        if (patternStart == '*') {
            int start;
            if (pattern.length() == 1) {
                return path.isEmpty() || path.charAt(0) != this.pathSeparator && this.isMatch(pattern, path.substring(1));
            }
            if (this.doubleAsteriskMatch(pattern, path)) {
                return true;
            }
            for (start = 0; start < path.length(); ++start) {
                if (!this.isMatch(pattern.substring(1), path.substring(start))) continue;
                return true;
            }
            return this.isMatch(pattern.substring(1), path.substring(start));
        }
        int pointer = this.skipBlanks(path);
        return !path.isEmpty() && (this.equal(path.charAt(pointer), patternStart) || patternStart == '?') && this.isMatch(pattern.substring(1), path.substring(pointer + 1));
    }

    private boolean doubleAsteriskMatch(String pattern, String path) {
        if (pattern.charAt(1) != '*') {
            return false;
        }
        if (pattern.length() > 2) {
            return this.isMatch(pattern.substring(3), path);
        }
        return false;
    }

    private int skipBlanks(String path) {
        int pointer;
        if (this.trimTokens) {
            for (pointer = 0; !path.isEmpty() && pointer < path.length() && path.charAt(pointer) == ' '; ++pointer) {
            }
        }
        return pointer;
    }

    private boolean equal(char pathChar, char patternChar) {
        if (this.ignoreCase) {
            return pathChar == patternChar || (pathChar > patternChar ? pathChar == patternChar + 32 : pathChar == patternChar - 32);
        }
        return pathChar == patternChar;
    }

    public static final class Builder {
        private char pathSeparator = (char)47;
        private boolean ignoreCase = false;
        private boolean matchStart = false;
        private boolean trimTokens = false;

        public Builder withPathSeparator(char pathSeparator) {
            this.pathSeparator = pathSeparator;
            return this;
        }

        public Builder withIgnoreCase() {
            this.ignoreCase = true;
            return this;
        }

        public Builder withMatchStart() {
            this.matchStart = true;
            return this;
        }

        public Builder withTrimTokens() {
            this.trimTokens = true;
            return this;
        }

        public AntPathMatcher build() {
            return new AntPathMatcher(this.pathSeparator, this.ignoreCase, this.matchStart, this.trimTokens);
        }
    }
}

