/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.io;

import com.google.common.base.Throwables;
import io.jarasandha.util.misc.CallerMustRelease;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.compression.SnappyFrameDecoder;
import io.netty.handler.codec.compression.SnappyFrameEncoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import java.net.SocketAddress;
import java.util.ArrayList;

public class Snappy {
    public static ByteBuf compress(ByteBufAllocator allocator, @CallerMustRelease ByteBuf raw) {
        CustomSnappyFrameEncoder encoder = new CustomSnappyFrameEncoder();
        int initialCapacity = Math.max(16, raw.readableBytes() / 4);
        ByteBuf compressedByteBuf = allocator.buffer(initialCapacity);
        try {
            encoder.encode(raw, compressedByteBuf);
        }
        catch (Throwable t) {
            compressedByteBuf.release();
            Throwables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException(t);
        }
        return compressedByteBuf;
    }

    public static ByteBuf decompress(ByteBufAllocator allocator, @CallerMustRelease ByteBuf compressed) {
        CustomSnappyFrameDecoder decoder = new CustomSnappyFrameDecoder();
        try {
            return decoder.decode(allocator, compressed);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static class AllocatorContext
    implements ChannelHandlerContext {
        private final ByteBufAllocator allocator;

        private AllocatorContext(ByteBufAllocator allocator) {
            this.allocator = allocator;
        }

        public Channel channel() {
            return null;
        }

        public EventExecutor executor() {
            return null;
        }

        public String name() {
            return null;
        }

        public ChannelHandler handler() {
            return null;
        }

        public boolean isRemoved() {
            return false;
        }

        public ChannelHandlerContext fireChannelRegistered() {
            return null;
        }

        public ChannelHandlerContext fireChannelUnregistered() {
            return null;
        }

        public ChannelHandlerContext fireChannelActive() {
            return null;
        }

        public ChannelHandlerContext fireChannelInactive() {
            return null;
        }

        public ChannelHandlerContext fireExceptionCaught(Throwable throwable) {
            return null;
        }

        public ChannelHandlerContext fireUserEventTriggered(Object o) {
            return null;
        }

        public ChannelHandlerContext fireChannelRead(Object o) {
            return null;
        }

        public ChannelHandlerContext fireChannelReadComplete() {
            return null;
        }

        public ChannelHandlerContext fireChannelWritabilityChanged() {
            return null;
        }

        public ChannelFuture bind(SocketAddress socketAddress) {
            return null;
        }

        public ChannelFuture connect(SocketAddress socketAddress) {
            return null;
        }

        public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress1) {
            return null;
        }

        public ChannelFuture disconnect() {
            return null;
        }

        public ChannelFuture close() {
            return null;
        }

        public ChannelFuture deregister() {
            return null;
        }

        public ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
            return null;
        }

        public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
            return null;
        }

        public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress1, ChannelPromise channelPromise) {
            return null;
        }

        public ChannelFuture disconnect(ChannelPromise channelPromise) {
            return null;
        }

        public ChannelFuture close(ChannelPromise channelPromise) {
            return null;
        }

        public ChannelFuture deregister(ChannelPromise channelPromise) {
            return null;
        }

        public ChannelHandlerContext read() {
            return null;
        }

        public ChannelFuture write(Object o) {
            return null;
        }

        public ChannelFuture write(Object o, ChannelPromise channelPromise) {
            return null;
        }

        public ChannelHandlerContext flush() {
            return null;
        }

        public ChannelFuture writeAndFlush(Object o, ChannelPromise channelPromise) {
            return null;
        }

        public ChannelFuture writeAndFlush(Object o) {
            return null;
        }

        public ChannelPromise newPromise() {
            return null;
        }

        public ChannelProgressivePromise newProgressivePromise() {
            return null;
        }

        public ChannelFuture newSucceededFuture() {
            return null;
        }

        public ChannelFuture newFailedFuture(Throwable throwable) {
            return null;
        }

        public ChannelPromise voidPromise() {
            return null;
        }

        public ChannelPipeline pipeline() {
            return null;
        }

        public ByteBufAllocator alloc() {
            return this.allocator;
        }

        @Deprecated
        public <T> Attribute<T> attr(AttributeKey<T> attributeKey) {
            return null;
        }

        @Deprecated
        public <T> boolean hasAttr(AttributeKey<T> attributeKey) {
            return false;
        }
    }

    private static class CustomSnappyFrameDecoder
    extends SnappyFrameDecoder {
        private CustomSnappyFrameDecoder() {
        }

        private ByteBuf decode(ByteBufAllocator allocator, ByteBuf in) throws Exception {
            ArrayList listOfByteBufs = new ArrayList();
            while (in.isReadable()) {
                super.decode((ChannelHandlerContext)new AllocatorContext(allocator), in, listOfByteBufs);
            }
            ArrayList sameListToBypassWeirdNettyApi = listOfByteBufs;
            return allocator.compositeBuffer(listOfByteBufs.size()).addComponents(true, sameListToBypassWeirdNettyApi);
        }
    }

    private static class CustomSnappyFrameEncoder
    extends SnappyFrameEncoder {
        private CustomSnappyFrameEncoder() {
        }

        private void encode(ByteBuf in, ByteBuf out) throws Exception {
            super.encode(null, in, out);
        }
    }
}

