/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.io;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.jarasandha.util.io.Snappy;
import io.jarasandha.util.misc.CallerMustRelease;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.function.Function;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ByteBufs {
    private static final Logger log = LoggerFactory.getLogger(ByteBufs.class);
    public static final int SIZE_BYTES_BOOLEAN = 1;
    public static final int SIZE_BYTES_SHORT = 2;
    public static final int SIZE_BYTES_INT = 4;
    public static final int SIZE_BYTES_LONG = 8;
    public static final int SIZE_BYTES_CHECKSUM = 8;
    public static final ByteBufAllocator UNPOOLED_HEAP_BASED_ALLOCATOR = new UnpooledByteBufAllocator(false);

    private ByteBufs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R mapAndApply(FileChannel fileChannel, long position, long size, Function<ByteBuf, R> action) throws IOException {
        MappedByteBuffer indexByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, position, size);
        try {
            R r;
            ByteBuf allIndexBlocksByteBuf = Unpooled.wrappedBuffer((ByteBuffer)indexByteBuffer);
            try {
                r = action.apply(allIndexBlocksByteBuf);
            }
            catch (Throwable throwable) {
                allIndexBlocksByteBuf.release();
                throw throwable;
            }
            allIndexBlocksByteBuf.release();
            return r;
        }
        finally {
            PlatformDependent.freeDirectBuffer((ByteBuffer)indexByteBuffer);
        }
    }

    public static int writeOptimized(@CallerMustRelease WritableByteChannel destination, @CallerMustRelease ByteBuf data, int pow2ChunkWriteSizeBytes) throws IOException {
        Preconditions.checkArgument((pow2ChunkWriteSizeBytes > 0 ? 1 : 0) != 0, (Object)"pow2ChunkWriteSizeBytes should be a positive int");
        Preconditions.checkArgument(((pow2ChunkWriteSizeBytes & pow2ChunkWriteSizeBytes - 1) == 0 ? 1 : 0) != 0, (Object)"pow2ChunkWriteSizeBytes is not a power of 2");
        int numBytesWritten = 0;
        if (destination instanceof SeekableByteChannel) {
            int readableBytes = data.readableBytes();
            long destinationSizeBeforeWrite = ((SeekableByteChannel)destination).size();
            int unalignedBytesStickingOut = Ints.checkedCast((long)(destinationSizeBeforeWrite & (long)(pow2ChunkWriteSizeBytes - 1)));
            int bytesToWriteBeforeAlignment = pow2ChunkWriteSizeBytes - unalignedBytesStickingOut;
            if (unalignedBytesStickingOut > 0 && readableBytes >= bytesToWriteBeforeAlignment) {
                ByteBuf unalignedData = data.slice(data.readerIndex(), bytesToWriteBeforeAlignment);
                int unalignedBytesWritten = ByteBufs.writeChunks(destination, unalignedData, bytesToWriteBeforeAlignment);
                Preconditions.checkState((unalignedBytesWritten == bytesToWriteBeforeAlignment ? 1 : 0) != 0);
                Preconditions.checkState(((((SeekableByteChannel)destination).size() & (long)(pow2ChunkWriteSizeBytes - 1)) == 0L ? 1 : 0) != 0);
                ByteBuf alignedData = data.slice(unalignedBytesWritten, readableBytes - unalignedBytesWritten);
                int alignedBytesWritten = ByteBufs.writeChunks(destination, alignedData, pow2ChunkWriteSizeBytes);
                Preconditions.checkState((readableBytes == (numBytesWritten += unalignedBytesWritten + alignedBytesWritten) ? 1 : 0) != 0);
                return numBytesWritten;
            }
        }
        return ByteBufs.writeChunks(destination, data, pow2ChunkWriteSizeBytes);
    }

    public static int writeChunks(@CallerMustRelease WritableByteChannel destination, @CallerMustRelease ByteBuf data, int chunkWriteSizeBytes) throws IOException {
        Preconditions.checkArgument((chunkWriteSizeBytes > 0 ? 1 : 0) != 0, (Object)"chunkWriteSizeBytes");
        int maxReadableBytes = data.readableBytes();
        int bytesWritten = 0;
        while (bytesWritten < maxReadableBytes) {
            ByteBuffer chunk = data.nioBuffer(bytesWritten, Math.min(chunkWriteSizeBytes, maxReadableBytes - bytesWritten));
            while (chunk.remaining() > 0) {
                bytesWritten += destination.write(chunk);
            }
        }
        Preconditions.checkState((maxReadableBytes == bytesWritten ? 1 : 0) != 0);
        return bytesWritten;
    }

    public static int write(@CallerMustRelease FileChannel destination, long positionToWriteTo, long numBytesToWrite, @CallerMustRelease ReadableByteChannel source) throws IOException {
        Preconditions.checkArgument((positionToWriteTo >= 0L ? 1 : 0) != 0, (Object)"positionToWriteTo");
        Preconditions.checkArgument((numBytesToWrite > 0L ? 1 : 0) != 0, (Object)"numBytesToWrite");
        int bytesWritten = 0;
        long position = positionToWriteTo;
        while ((long)bytesWritten < numBytesToWrite) {
            long c = destination.transferFrom(source, position, numBytesToWrite - (long)bytesWritten);
            position += c;
            bytesWritten = (int)((long)bytesWritten + c);
        }
        Preconditions.checkState((numBytesToWrite == (long)bytesWritten ? 1 : 0) != 0);
        return bytesWritten;
    }

    public static ByteBuf compress(ByteBufAllocator allocator, @CallerMustRelease ByteBuf decompressed) {
        int decompressedByteSize = decompressed.readableBytes();
        ByteBuf compressed = Snappy.compress(allocator, decompressed);
        log.trace("The decompressed size was [{}] bytes and compressed is [{}] bytes", (Object)decompressedByteSize, (Object)compressed.readableBytes());
        return compressed;
    }

    public static ByteBuf decompress(ByteBufAllocator allocator, @CallerMustRelease ByteBuf compressed) {
        int compressedByteSize = compressed.readableBytes();
        ByteBuf decompressed = Snappy.decompress(allocator, compressed);
        log.trace("The compressed size was [{}] bytes and decompressed is [{}] bytes", (Object)compressedByteSize, (Object)decompressed.readableBytes());
        return decompressed;
    }

    public static long calculateChecksum(@CallerMustRelease ByteBuf givenByteBuf) {
        int readableByteCount;
        if (givenByteBuf.isDirect() && givenByteBuf.nioBufferCount() == 1) {
            return ByteBufs.calculateChecksumNio(givenByteBuf);
        }
        ByteBuf byteBuf = givenByteBuf.asReadOnly();
        CRC32 crc32 = new CRC32();
        byte[] bytes = new byte[Math.min(1024, byteBuf.readableBytes())];
        while ((readableByteCount = byteBuf.readableBytes()) > 0) {
            int numBytesToRead = Math.min(bytes.length, readableByteCount);
            byteBuf.readBytes(bytes, 0, numBytesToRead);
            crc32.update(bytes, 0, numBytesToRead);
        }
        return crc32.getValue();
    }

    @VisibleForTesting
    static long calculateChecksumNio(ByteBuf directSingleNioBuf) {
        CRC32 crc32 = new CRC32();
        ByteBuffer byteBuffer = directSingleNioBuf.nioBuffer();
        crc32.update(byteBuffer);
        return crc32.getValue();
    }
}

