/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadFactories {
    private static final Logger log = LoggerFactory.getLogger(ThreadFactories.class);

    private ThreadFactories() {
    }

    public static ThreadFactory newDaemonThreadFactory(String nameFormat) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(nameFormat).setUncaughtExceptionHandler((thread, throwable) -> log.error("Error occurred on thread [" + thread.getName() + "]", throwable)).build();
    }
}

