/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class GuardedSession<I> {
    private final int concurrentPermits;
    private final Semaphore semaphore;
    private volatile I item;

    public GuardedSession(I item) {
        this(1, item);
    }

    public GuardedSession(int concurrentPermits, I item) {
        Preconditions.checkArgument((concurrentPermits > 0 ? 1 : 0) != 0, (Object)"concurrentPermits");
        this.concurrentPermits = concurrentPermits;
        this.semaphore = new Semaphore(concurrentPermits);
        this.item = Preconditions.checkNotNull(item);
    }

    public boolean access(Consumer<? super I> consumer) throws InterruptedException {
        return this.access(Integer.MAX_VALUE, TimeUnit.SECONDS, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean access(long waitDuration, TimeUnit waitDurationUnits, Consumer<? super I> consumer) throws InterruptedException {
        I borrowed = this.borrow(waitDuration, waitDurationUnits);
        if (borrowed != null) {
            try {
                consumer.accept(borrowed);
                boolean bl = true;
                return bl;
            }
            finally {
                this.back(borrowed);
            }
        }
        return false;
    }

    @VisibleForTesting
    I borrow() throws InterruptedException {
        return this.borrow(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    @VisibleForTesting
    I borrow(long waitDuration, TimeUnit waitDurationUnits) throws InterruptedException {
        long startNanos;
        long endNanos;
        I i = null;
        for (long waitNanos = TimeUnit.NANOSECONDS.convert(waitDuration, waitDurationUnits); this.item != null && waitNanos > 0L; waitNanos -= endNanos - startNanos) {
            startNanos = System.nanoTime();
            if (this.semaphore.tryAcquire(waitNanos, TimeUnit.NANOSECONDS)) {
                i = this.item;
                break;
            }
            endNanos = System.nanoTime();
        }
        return i;
    }

    @VisibleForTesting
    void back(I borrowedItem) {
        Preconditions.checkArgument((borrowedItem == this.item ? 1 : 0) != 0);
        this.semaphore.release();
    }

    public I discard() throws InterruptedException {
        I i = null;
        while (this.item != null) {
            if (!this.semaphore.tryAcquire(this.concurrentPermits, 1000L, TimeUnit.MILLISECONDS)) continue;
            i = this.item;
            this.item = null;
            break;
        }
        return i;
    }
}

