/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancellableTask<T>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CancellableTask.class);
    private static final int STATE_NOT_STARTED = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_CANCELLED_NEVER_STARTED = 2;
    private static final int STATE_DONE_OR_INTERRUPTED_OR_ERROR = 3;
    private final Callable<T> mainTask;
    private final Consumer<T> onSuccessTask;
    private final Consumer<Throwable> onFailureTask;
    private final AtomicStampedReference<Thread> stateAndRunner;

    public CancellableTask(Callable<T> mainTask, Consumer<T> onSuccessTask, Consumer<Throwable> onFailureTask) {
        this.mainTask = mainTask;
        this.onSuccessTask = onSuccessTask;
        this.onFailureTask = onFailureTask;
        this.stateAndRunner = new AtomicStampedReference<Object>(null, 0);
    }

    @Override
    public void run() {
        if (this.stateAndRunner.compareAndSet(null, Thread.currentThread(), 0, 1)) {
            try {
                T result;
                try {
                    result = this.mainTask.call();
                }
                finally {
                    this.stateAndRunner.set(null, 3);
                }
                this.onSuccessTask.accept(result);
            }
            catch (Throwable throwable) {
                this.onFailureTask.accept(throwable);
            }
        } else {
            throw new IllegalStateException("Task was already done or cancelled");
        }
    }

    public void cancel() {
        if (this.stateAndRunner.compareAndSet(null, null, 0, 2)) {
            this.onFailureTask.accept(new CancellationException("Task has been cancelled"));
        } else {
            Thread runner = this.stateAndRunner.getReference();
            if (runner != null) {
                runner.interrupt();
            }
        }
    }
}

