/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.collection;

import com.google.common.base.Preconditions;
import java.util.AbstractList;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;

public class SparseFixedSizeList<V>
extends AbstractList<V> {
    private final MutableIntObjectMap<V> internalMap;
    private final int fixedVirtualSize;
    private final V defaultValue;

    public SparseFixedSizeList(int fixedVirtualSize, V defaultValue) {
        Preconditions.checkArgument((fixedVirtualSize >= 0 ? 1 : 0) != 0, (Object)"fixedVirtualSize has to be 0 or greater");
        this.internalMap = new IntObjectHashMap(Math.max(4, fixedVirtualSize / 8));
        this.fixedVirtualSize = fixedVirtualSize;
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean add(V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, V element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V set(int index, V element) {
        Preconditions.checkElementIndex((int)index, (int)this.fixedVirtualSize);
        Object value = element == null || element == this.defaultValue ? this.internalMap.remove(index) : this.internalMap.put(index, element);
        return (V)(value == null ? this.defaultValue : value);
    }

    @Override
    public V get(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.fixedVirtualSize);
        Object value = this.internalMap.get(index);
        return (V)(value == null ? this.defaultValue : value);
    }

    @Override
    public int size() {
        return this.fixedVirtualSize;
    }
}

