/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.collection;

import com.google.common.base.MoreObjects;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.jarasandha.util.collection.Ints;
import java.util.function.IntConsumer;
import org.apache.lucene.util.packed.PackedLongValues;

public class PackedIntsWrapper
implements Ints {
    private final PackedLongValues actual;

    public PackedIntsWrapper(PackedLongValues.Builder builder) {
        this(builder.build());
    }

    public PackedIntsWrapper(PackedLongValues actual) {
        com.google.common.primitives.Ints.checkedCast((long)actual.size());
        this.actual = actual;
    }

    public static PackedLongValues.Builder builder() {
        return PackedLongValues.packedBuilder((float)0.0f);
    }

    @Override
    public int size() {
        return (int)this.actual.size();
    }

    @Override
    public int get(int index) {
        return (int)this.actual.get(index);
    }

    @Override
    public void forEach(IntConsumer intConsumer) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            intConsumer.accept(this.get(i));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackedIntsWrapper)) {
            return false;
        }
        PackedIntsWrapper that = (PackedIntsWrapper)o;
        int size = this.size();
        if (size == that.size()) {
            int i;
            for (i = 0; i < size && this.get(i) == that.get(i); ++i) {
            }
            return i == size;
        }
        return false;
    }

    public int hashCode() {
        Hasher hasher = Hashing.adler32().newHasher();
        this.forEach(arg_0 -> ((Hasher)hasher).putInt(arg_0));
        return hasher.hash().asInt();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("size", this.actual.size()).toString();
    }
}

