/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.collection;

import java.util.BitSet;

public interface ImmutableBitSet {
    public static final int POSITION_NOT_SET = -1;

    public int nextSetBit(int var1);

    default public boolean get(int position) {
        return position == this.nextSetBit(position);
    }

    public static ImmutableBitSet newBitSetWithAllPositionsTrue() {
        return new AllTrueBitSet();
    }

    public static ImmutableBitSet newBitSet(int ... truePositions) {
        BitSet bitSet = new BitSet();
        for (int i : truePositions) {
            bitSet.set(i);
        }
        return ImmutableBitSet.newBitSet(bitSet);
    }

    public static ImmutableBitSet newBitSet(BitSet truePositions) {
        return new SelectiveBitSet(truePositions);
    }

    public static class AllTrueBitSet
    implements ImmutableBitSet {
        private AllTrueBitSet() {
        }

        @Override
        public int nextSetBit(int fromPosition) {
            return fromPosition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AllTrueBitSet)) {
                return false;
            }
            AllTrueBitSet other = (AllTrueBitSet)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof AllTrueBitSet;
        }

        public int hashCode() {
            int result = 1;
            return result;
        }
    }

    public static class SelectiveBitSet
    implements ImmutableBitSet {
        private final BitSet bitSet;

        private SelectiveBitSet(BitSet bitSet) {
            this.bitSet = bitSet;
        }

        @Override
        public int nextSetBit(int fromPosition) {
            return this.bitSet.nextSetBit(fromPosition);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SelectiveBitSet)) {
                return false;
            }
            SelectiveBitSet other = (SelectiveBitSet)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BitSet this$bitSet = this.bitSet;
            BitSet other$bitSet = other.bitSet;
            return !(this$bitSet == null ? other$bitSet != null : !((Object)this$bitSet).equals(other$bitSet));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SelectiveBitSet;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BitSet $bitSet = this.bitSet;
            result = result * 59 + ($bitSet == null ? 43 : ((Object)$bitSet).hashCode());
            return result;
        }
    }
}

