/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.concurrent;

import io.jarasandha.util.concurrent.ManagedReference;
import io.netty.util.IllegalReferenceCountException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedReferenceTest {
    private static final Logger log = LoggerFactory.getLogger(ManagedReferenceTest.class);
    private Predicate<Integer> verifier;
    private Consumer<Integer> deallocator;

    @Before
    public void setUp() {
        this.verifier = (Predicate)Mockito.mock(Predicate.class);
        Mockito.when((Object)this.verifier.test(Matchers.anyInt())).thenReturn((Object)true);
        this.deallocator = (Consumer)Mockito.mock(Consumer.class);
    }

    @Test
    public void test_basic() {
        int sampleInt = 123;
        ManagedReference mr = new ManagedReference((Object)123, this.verifier, this.deallocator);
        Assert.assertEquals((long)1L, (long)mr.refCnt());
        Assert.assertEquals((Object)new Integer(123), (Object)mr.actualRef());
        mr.release();
        Assert.assertEquals((long)0L, (long)mr.refCnt());
        ((Predicate)Mockito.verify(this.verifier, (VerificationMode)Mockito.times((int)1))).test(123);
        ((Consumer)Mockito.verify(this.deallocator, (VerificationMode)Mockito.times((int)1))).accept(123);
        Assert.assertNull((Object)mr.actualRef());
    }

    @Test
    public void test_multipleRetains() {
        int sampleInt = 123;
        ManagedReference mr = new ManagedReference((Object)123, this.verifier, this.deallocator);
        Assert.assertEquals((Object)new Integer(123), (Object)mr.actualRef());
        Assert.assertEquals((long)1L, (long)mr.refCnt());
        mr.retain();
        Assert.assertEquals((long)2L, (long)mr.refCnt());
        mr.release();
        Assert.assertEquals((long)1L, (long)mr.refCnt());
        mr.retain(3);
        Assert.assertEquals((long)4L, (long)mr.refCnt());
        mr.release(4);
        Assert.assertEquals((long)0L, (long)mr.refCnt());
        ((Predicate)Mockito.verify(this.verifier, (VerificationMode)Mockito.times((int)3))).test(123);
        ((Consumer)Mockito.verify(this.deallocator, (VerificationMode)Mockito.times((int)1))).accept(123);
        Assert.assertNull((Object)mr.actualRef());
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void test_failedVerification_throwsIllegalRef() {
        new ManagedReference((Object)123, integer -> false, this.deallocator);
    }

    @Test
    public void test_basic_autocloseable() {
        AtomicBoolean closed = new AtomicBoolean(false);
        Stream sampleStream = (Stream)Stream.of(Integer.valueOf(123)).onClose(() -> closed.set(true));
        ManagedReference mr = ManagedReference.newManagedReference((AutoCloseable)sampleStream);
        Assert.assertFalse((boolean)closed.get());
        Assert.assertEquals((long)1L, (long)mr.refCnt());
        Assert.assertSame((Object)sampleStream, (Object)mr.actualRef());
        mr.release();
        Assert.assertEquals((long)0L, (long)mr.refCnt());
        Assert.assertTrue((boolean)closed.get());
        Assert.assertNull((Object)mr.actualRef());
    }
}

