/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.collection;

import io.jarasandha.util.collection.SparseFixedSizeList;
import io.jarasandha.util.test.AbstractTest;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparseFixedSizeListTest
extends AbstractTest {
    private static final Logger log = LoggerFactory.getLogger(SparseFixedSizeListTest.class);

    @Test
    public void testBasic() {
        SparseFixedSizeList list = new SparseFixedSizeList(0, null);
        Assert.assertEquals((long)0L, (long)list.size());
        for (String s : list) {
            Assert.fail((String)"Iterator should not have iterated as size is 0");
        }
        try {
            list.get(0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            log.trace("Expected", (Throwable)e);
        }
        try {
            list.add((Object)"hello");
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            log.trace("Expected", (Throwable)e);
        }
        try {
            list.add(0, (Object)"hello");
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            log.trace("Expected", (Throwable)e);
        }
        Assert.assertFalse((boolean)list.remove((Object)"hello"));
        try {
            list.remove(0);
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            log.trace("Expected", (Throwable)e);
        }
    }

    @Test
    public void testSizeOne() {
        String defaultValue = "Hello";
        SparseFixedSizeList list = new SparseFixedSizeList(1, (Object)"Hello");
        Assert.assertEquals((long)1L, (long)list.size());
        for (Object s : list) {
            Assert.assertEquals((Object)"Hello", (Object)s);
        }
        Assert.assertEquals((Object)"Hello", (Object)list.get(0));
        String newValue = "world";
        Assert.assertEquals((Object)"Hello", (Object)list.set(0, (Object)"world"));
        Assert.assertEquals((Object)"world", (Object)list.get(0));
        Assert.assertEquals((long)1L, (long)list.size());
        for (String s : list) {
            Assert.assertEquals((Object)"world", (Object)s);
        }
        Assert.assertEquals((Object)"world", (Object)list.get(0));
        try {
            list.remove((Object)"world");
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            log.trace("Expected", (Throwable)e);
        }
    }

    @Test
    public void testSparse() {
        String defaultValue = "Hello";
        SparseFixedSizeList list = new SparseFixedSizeList(100, (Object)"Hello");
        Assert.assertEquals((long)100L, (long)list.size());
        for (String s : list) {
            Assert.assertEquals((Object)"Hello", (Object)s);
        }
        Assert.assertEquals((Object)"Hello", (Object)list.get(0));
        Assert.assertEquals((Object)"Hello", (Object)list.get(34));
        Assert.assertEquals((Object)"Hello", (Object)list.get(67));
        Assert.assertEquals((Object)"Hello", (Object)list.get(99));
        String newValue = "world";
        list.set(49, (Object)"world");
        Assert.assertEquals((Object)"world", (Object)list.get(49));
        Assert.assertEquals((long)100L, (long)list.size());
        int i = 0;
        for (String s : list) {
            Assert.assertEquals((Object)(i == 49 ? "world" : "Hello"), (Object)s);
            ++i;
        }
    }
}

