/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.misc;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

public abstract class ProgrammaticLogManager {
    public static final String LOG_PATTERN_LONG = "[%date{ISO8601}] [%-5level] [%thread] [%logger{16}] - %msg%n";
    public static final String LOG_PATTERN_SMALL = "[%relative] %msg%n";

    private ProgrammaticLogManager() {
    }

    public static void setLoggerLevel(String logPattern, Level appendedLogLevel, Map<String, Level> loggersAndLevels) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.reset();
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern(logPattern);
        ple.setContext((Context)loggerContext);
        ple.start();
        ConsoleAppender console = new ConsoleAppender();
        console.setEncoder((Encoder)ple);
        console.setContext((Context)loggerContext);
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(appendedLogLevel.toString());
        console.addFilter((Filter)filter);
        console.start();
        Map<String, Level> map = loggersAndLevels;
        if (map == null || map.isEmpty()) {
            map = new HashMap<String, Level>();
            map.put("ROOT", appendedLogLevel);
        }
        map.putIfAbsent("ROOT", Level.WARN);
        for (Map.Entry<String, Level> entry : map.entrySet()) {
            Logger logger = loggerContext.getLogger(entry.getKey());
            logger.setLevel(entry.getValue());
            if (!"ROOT".equals(entry.getKey())) continue;
            logger.addAppender((Appender)console);
        }
    }
}

