/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.misc;

import com.google.common.base.Preconditions;
import io.jarasandha.util.misc.Validateable;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class Duration
implements Validateable<Duration> {
    @Min(value=1L)
    private long time;
    @NotNull
    @Valid
    private ChronoUnit unit;

    @Override
    public Duration validate() {
        Preconditions.checkArgument((this.time >= 0L ? 1 : 0) != 0, (String)"time [%s] has to be a positive integer", (long)this.time);
        Preconditions.checkArgument((this.unit != null ? 1 : 0) != 0, (String)"unit [%s] has to be provided %s", (Object)String.valueOf(this.unit), Arrays.asList(ChronoUnit.values()));
        return this;
    }

    public java.time.Duration toJavaDuration() {
        return java.time.Duration.of(this.time, this.unit);
    }

    public long getTime() {
        return this.time;
    }

    public ChronoUnit getUnit() {
        return this.unit;
    }

    public Duration setTime(long time) {
        this.time = time;
        return this;
    }

    public Duration setUnit(ChronoUnit unit) {
        this.unit = unit;
        return this;
    }
}

