/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.misc;

import com.google.common.base.Preconditions;
import io.jarasandha.util.misc.Validateable;
import java.util.Arrays;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class ByteSize
implements Validateable<ByteSize> {
    @Min(value=1L)
    private long value;
    @NotNull
    @Valid
    private Unit unit;

    public static ByteSize of(long value, Unit unit) {
        return new ByteSize().setUnit(unit).setValue(value);
    }

    @Override
    public ByteSize validate() {
        Preconditions.checkArgument((this.value >= 0L ? 1 : 0) != 0, (String)"value [%s] has to be a positive integer", (long)this.value);
        Preconditions.checkArgument((this.unit != null ? 1 : 0) != 0, (String)"unit [%s] has to be provided %s", (Object)String.valueOf((Object)this.unit), Arrays.asList(Unit.values()));
        return this;
    }

    public long toBytes() {
        return this.value * this.unit.toBytes();
    }

    public long getValue() {
        return this.value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public ByteSize setValue(long value) {
        this.value = value;
        return this;
    }

    public ByteSize setUnit(Unit unit) {
        this.unit = unit;
        return this;
    }

    public static enum Unit {
        BYTES,
        KILOBYTES,
        MEGABYTES,
        GIGABYTES,
        TERABYTES,
        PETABYTES,
        EXABYTES;


        public long toBytes() {
            long size = 1L;
            switch (this) {
                case EXABYTES: {
                    size *= 1024L;
                }
                case PETABYTES: {
                    size *= 1024L;
                }
                case TERABYTES: {
                    size *= 1024L;
                }
                case GIGABYTES: {
                    size *= 1024L;
                }
                case MEGABYTES: {
                    size *= 1024L;
                }
                case KILOBYTES: {
                    size *= 1024L;
                }
                case BYTES: {
                    return size;
                }
            }
            throw new IllegalArgumentException("Unrecognized unit");
        }
    }
}

