/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.io;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleasableByteBufs
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ReleasableByteBufs.class);
    private final Collection<? extends ByteBuf> byteBufs;

    public ReleasableByteBufs(ByteBuf ... byteBufs) {
        this.byteBufs = Lists.newArrayList((Object[])byteBufs);
    }

    public ReleasableByteBufs(Collection<? extends ByteBuf> byteBufs) {
        this.byteBufs = byteBufs;
    }

    @Override
    public void close() {
        Iterator<? extends ByteBuf> iterator = this.byteBufs.iterator();
        while (iterator.hasNext()) {
            ByteBuf byteBuf = iterator.next();
            if (byteBuf.refCnt() > 0) {
                try {
                    byteBuf.release();
                }
                catch (Throwable t) {
                    log.warn("Error occurred while releasing a " + ByteBuf.class.getSimpleName(), t);
                }
            }
            iterator.remove();
        }
    }
}

