/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.concurrent;

import com.google.common.base.Preconditions;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.IllegalReferenceCountException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManagedReference<T>
extends AbstractReferenceCounted {
    private static final Logger log = LoggerFactory.getLogger(ManagedReference.class);
    private static final String ERR_MSG_VERIFICATION_FAILED = "The verification was not successful";
    private static final String ERR_MSG_DEALLOCATION_FAILED = "Error occurred during de-allocation";
    private static final IllegalReferenceCountException FIXED_EX_VERIFICATION_FAILED = new IllegalReferenceCountException("The verification was not successful");
    private volatile T actualRef;
    private volatile Predicate<T> retainVerifier;
    private volatile Consumer<T> deallocator;

    public ManagedReference(T actualRef, Predicate<T> retainVerifier, Consumer<T> deallocator) {
        this.actualRef = Preconditions.checkNotNull(actualRef, (Object)"actualRef");
        this.retainVerifier = (Predicate)Preconditions.checkNotNull(retainVerifier, (Object)"retainVerifier");
        this.deallocator = (Consumer)Preconditions.checkNotNull(deallocator, (Object)"deallocator");
        try {
            ManagedReference.verify(actualRef, retainVerifier);
        }
        catch (IllegalReferenceCountException e) {
            deallocator.accept(actualRef);
            throw e;
        }
    }

    public static <TC extends AutoCloseable> ManagedReference<TC> newManagedReference(TC actualRef) {
        return new ManagedReference<AutoCloseable>(actualRef, refToVerify -> true, refToDeallocate -> {
            try {
                refToDeallocate.close();
            }
            catch (Throwable throwable) {
                log.warn(ERR_MSG_DEALLOCATION_FAILED, throwable);
            }
        });
    }

    public T actualRef() {
        return this.actualRef;
    }

    public ManagedReference<T> retain() {
        return this.retain(1);
    }

    public ManagedReference<T> retain(int increment) {
        try {
            ManagedReference.verify(this.actualRef, this.retainVerifier);
        }
        catch (IllegalReferenceCountException e) {
            while (this.refCnt() > 0 && !this.release()) {
            }
            throw e;
        }
        super.retain(increment);
        return this;
    }

    private static <T> void verify(T reference, Predicate<T> verifier) {
        if (!verifier.test(reference)) {
            throw FIXED_EX_VERIFICATION_FAILED;
        }
    }

    public ManagedReference<T> touch() {
        super.touch();
        return this;
    }

    public ManagedReference<T> touch(Object hint) {
        return this;
    }

    protected void deallocate() {
        T actualRefCopy = this.actualRef;
        Consumer<T> deallocatorCopy = this.deallocator;
        this.actualRef = null;
        this.deallocator = null;
        this.retainVerifier = null;
        try {
            deallocatorCopy.accept(actualRefCopy);
        }
        catch (Throwable throwable) {
            log.warn(ERR_MSG_DEALLOCATION_FAILED, throwable);
        }
    }
}

