/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.io;

import io.jarasandha.util.io.ByteBufs;
import io.jarasandha.util.misc.Formatters;
import io.jarasandha.util.test.AbstractTest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnappyTest {
    private static final Logger log = LoggerFactory.getLogger(SnappyTest.class);
    private static final byte[] TEST_BYTES = "[32] But I must explain to you how all this mistaken idea of denouncing of a\npleasure and praising pain was born and I will give you a complete account of\nthe system, and expound the actual teachings of the great explorer of the truth,\nthe master-builder of human happiness. No one rejects, dislikes, or avoids\npleasure itself, because it is pleasure, but because those who do not know how\nto pursue pleasure rationally encounter consequences that are extremely painful.\nNor again is there anyone who loves or pursues or desires to obtain pain of\nitself, because it is pain, but occasionally circumstances occur in which toil\nand pain can procure him some great pleasure. To take a trivial example, which\nof us ever undertakes laborious physical exercise, except to obtain some\nadvantage from it? But who has any right to find fault with a man who chooses to\nenjoy a pleasure that has no annoying consequences, or one who avoids a pain\nthat produces no resultant pleasure?\n\n[33] On the other hand, we denounce with righteous indignation and dislike men\nwho are so beguiled and demoralized by the charms of pleasure of the moment, so\nblinded by desire, that they cannot foresee the pain and trouble that are bound\nto ensue; and equal blame belongs to those who fail in their duty through\nweakness of will, which is the same as saying through shrinking from toil and\npain. These cases are perfectly simple and easy to distinguish. In a free hour,\nwhen our power of choice is untrammeled and when nothing prevents our being able\nto do what we like best, every pleasure is to be welcomed and every pain\navoided. But in certain circumstances and owing to the claims of duty or the\nobligations of business it will frequently occur that pleasures have to be\nrepudiated and annoyances accepted. The wise man therefore always holds in these\nmatters to this principle of selection: he rejects pleasures to secure other\ngreater pleasures, or else he endures pains to avoid worse pains ohs.\n".getBytes(StandardCharsets.UTF_8);

    @After
    public void afterTest() {
        AbstractTest.triggerGc();
    }

    @Test
    public void testSnappyLarge() {
        SnappyTest.runTest(TEST_BYTES, 9371);
    }

    @Test
    public void testSnappyMedium() {
        SnappyTest.runTest(TEST_BYTES, 1);
    }

    @Test
    public void testSnappySmall() {
        SnappyTest.runTest(new byte[]{1, 3, 40, -3, 47}, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runTest(byte[] testBytes, int numTestByteComponents) {
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true);
        CompositeByteBuf rawByteBuf = allocator.compositeBuffer();
        for (int i = 0; i < numTestByteComponents; ++i) {
            rawByteBuf.addComponents(true, new ByteBuf[]{Unpooled.wrappedBuffer((byte[])testBytes)});
        }
        int rawByteBufLength = rawByteBuf.readableBytes();
        log.info("Data size [{}]", (Object)Formatters.format((long)rawByteBufLength));
        long rawByteBufChecksum = ByteBufs.calculateChecksum((ByteBuf)rawByteBuf);
        long slowRawByteBufChecksum = ByteBufs.calculateChecksumNio((ByteBuf)rawByteBuf);
        log.info("Checksum production: [{}], test: [{}]", (Object)rawByteBufChecksum, (Object)slowRawByteBufChecksum);
        Assert.assertEquals((long)rawByteBufChecksum, (long)slowRawByteBufChecksum);
        try {
            ByteBuf newRawByteBuf;
            ByteBuf compressedByteBuf = ByteBufs.compress((ByteBufAllocator)allocator, (ByteBuf)rawByteBuf);
            log.info("Raw [{}], compressed [{}]", (Object)Formatters.format((long)rawByteBufLength), (Object)Formatters.format((long)compressedByteBuf.readableBytes()));
            try {
                newRawByteBuf = ByteBufs.decompress((ByteBufAllocator)allocator, (ByteBuf)compressedByteBuf);
            }
            finally {
                compressedByteBuf.release();
            }
            try {
                log.info("Decompressed [{}], raw [{}]", (Object)Formatters.format((long)newRawByteBuf.readableBytes()), (Object)Formatters.format((long)rawByteBufLength));
                Assert.assertEquals((long)rawByteBufLength, (long)newRawByteBuf.readableBytes());
                rawByteBuf.resetReaderIndex();
                Assert.assertEquals((long)0L, (long)ByteBufUtil.compare((ByteBuf)rawByteBuf, (ByteBuf)newRawByteBuf));
                long newRawByteBufChecksum = ByteBufs.calculateChecksum((ByteBuf)newRawByteBuf);
                long slowNewRawByteBufChecksum = ByteBufs.calculateChecksumNio((ByteBuf)newRawByteBuf);
                log.info("Checksum production: [{}], test: [{}]", (Object)newRawByteBufChecksum, (Object)slowNewRawByteBufChecksum);
                Assert.assertEquals((long)rawByteBufChecksum, (long)newRawByteBufChecksum);
                Assert.assertEquals((long)rawByteBufChecksum, (long)slowNewRawByteBufChecksum);
            }
            finally {
                newRawByteBuf.release();
            }
        }
        finally {
            rawByteBuf.release();
        }
    }
}

