/*
 * Decompiled with CFR 0.152.
 */
package io.jarasandha.util.io;

import com.google.common.collect.Lists;
import io.jarasandha.util.io.ByteBufs;
import io.jarasandha.util.misc.Uuids;
import io.jarasandha.util.test.AbstractTestWithAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBufsTest
extends AbstractTestWithAllocator {
    private static final Logger log = LoggerFactory.getLogger(ByteBufsTest.class);
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testUuidBytesSize() throws Exception {
        Assert.assertEquals((long)16L, (long)Uuids.newUuidByteBuf().readableBytes());
        Assert.assertEquals((long)16L, (long)Uuids.bytesFromUuid((UUID)UUID.randomUUID()).length);
    }

    @Test
    public void testWriteOptimized_NonSeekable_NoAlignedWrite() throws IOException {
        Throwable throwable;
        int pageSize = 1024;
        File file = this.folder.newFile();
        ArrayList writeSizes = new ArrayList();
        try (ByteBufOutputStream baos = new ByteBufOutputStream(Unpooled.buffer());){
            throwable = null;
            try (WritableByteChannel wbcOrig = Channels.newChannel((OutputStream)baos);){
                WritableByteChannel wbc = (WritableByteChannel)Mockito.mock(WritableByteChannel.class);
                Mockito.when((Object)wbc.write((ByteBuffer)Matchers.any(ByteBuffer.class))).thenAnswer(invocationOnMock -> {
                    ByteBuffer bb = (ByteBuffer)invocationOnMock.getArguments()[0];
                    int c = wbcOrig.write(bb);
                    writeSizes.add(c);
                    return c;
                });
                ByteBuf bb = Unpooled.buffer();
                int numPhase1Uuids = 10;
                for (int i = 0; i < 10; ++i) {
                    bb.writeBytes(Uuids.newUuidByteBuf());
                }
                Assert.assertTrue((bb.readableBytes() < 1024 ? 1 : 0) != 0);
                Assert.assertEquals((long)160L, (long)bb.readableBytes());
                ByteBufs.writeOptimized((WritableByteChannel)wbc, (ByteBuf)bb, (int)1024);
                Assert.assertEquals((long)160L, (long)baos.writtenBytes());
                ((WritableByteChannel)Mockito.verify((Object)wbc, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)Matchers.any(ByteBuffer.class));
            }
            catch (Throwable wbc) {
                throwable = wbc;
                throw wbc;
            }
        }
        long phase1Size = file.length();
        throwable = null;
        try (ByteBufOutputStream baos = new ByteBufOutputStream(Unpooled.buffer());
             WritableByteChannel wbcOrig = Channels.newChannel((OutputStream)baos);){
            WritableByteChannel wbc = (WritableByteChannel)Mockito.mock(WritableByteChannel.class);
            Mockito.when((Object)wbc.write((ByteBuffer)Matchers.any(ByteBuffer.class))).thenAnswer(invocationOnMock -> {
                ByteBuffer bb = (ByteBuffer)invocationOnMock.getArguments()[0];
                int c = wbcOrig.write(bb);
                writeSizes.add(c);
                return c;
            });
            ByteBuf bb = Unpooled.buffer();
            int numPhase2Uuids = 500;
            for (int i = 0; i < 500; ++i) {
                bb.writeBytes(Uuids.newUuidByteBuf());
            }
            long phase2Size = bb.readableBytes();
            Assert.assertTrue((phase2Size > 3072L ? 1 : 0) != 0);
            Assert.assertEquals((long)8000L, (long)phase2Size);
            ByteBufs.writeOptimized((WritableByteChannel)wbc, (ByteBuf)bb, (int)1024);
            Assert.assertEquals((long)(phase1Size + phase2Size), (long)baos.writtenBytes());
            ((WritableByteChannel)Mockito.verify((Object)wbc, (VerificationMode)Mockito.times((int)((int)Math.ceil((double)phase2Size / 1024.0))))).write((ByteBuffer)Matchers.any(ByteBuffer.class));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Integer[]{160, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 832}), writeSizes);
    }

    @Test
    public void testWriteOptimized_Seekable_AlignedWrite() throws IOException {
        int pageSize = 1024;
        File file = this.folder.newFile();
        ArrayList writeSizes = new ArrayList();
        try (FileChannel fcOrig = FileChannel.open(file.toPath(), StandardOpenOption.WRITE);){
            FileChannel fc = (FileChannel)Mockito.mock(FileChannel.class);
            Mockito.when((Object)fc.size()).thenAnswer(invocationOnMock -> fcOrig.size());
            Mockito.when((Object)fc.write((ByteBuffer)Matchers.any(ByteBuffer.class))).thenAnswer(invocationOnMock -> {
                ByteBuffer bb = (ByteBuffer)invocationOnMock.getArguments()[0];
                int c = fcOrig.write(bb);
                writeSizes.add(c);
                return c;
            });
            ByteBuf bb = Unpooled.buffer();
            int numPhase1Uuids = 10;
            for (int i = 0; i < 10; ++i) {
                bb.writeBytes(Uuids.newUuidByteBuf());
            }
            Assert.assertTrue((bb.readableBytes() < 1024 ? 1 : 0) != 0);
            Assert.assertEquals((long)160L, (long)bb.readableBytes());
            ByteBufs.writeOptimized((WritableByteChannel)fc, (ByteBuf)bb, (int)1024);
            Assert.assertEquals((long)160L, (long)fcOrig.size());
            ((FileChannel)Mockito.verify((Object)fc, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)Matchers.any(ByteBuffer.class));
        }
        long phase1Size = file.length();
        try (FileChannel fcOrig = FileChannel.open(file.toPath(), StandardOpenOption.APPEND);){
            FileChannel fc = (FileChannel)Mockito.mock(FileChannel.class);
            Mockito.when((Object)fc.size()).thenAnswer(invocationOnMock -> fcOrig.size());
            Mockito.when((Object)fc.write((ByteBuffer)Matchers.any(ByteBuffer.class))).thenAnswer(invocationOnMock -> {
                ByteBuffer bb = (ByteBuffer)invocationOnMock.getArguments()[0];
                int c = fcOrig.write(bb);
                writeSizes.add(c);
                return c;
            });
            ByteBuf bb = Unpooled.buffer();
            int numPhase2Uuids = 500;
            for (int i = 0; i < 500; ++i) {
                bb.writeBytes(Uuids.newUuidByteBuf());
            }
            long phase2Size = bb.readableBytes();
            Assert.assertTrue((phase2Size > 3072L ? 1 : 0) != 0);
            Assert.assertEquals((long)8000L, (long)phase2Size);
            ByteBufs.writeOptimized((WritableByteChannel)fc, (ByteBuf)bb, (int)1024);
            Assert.assertEquals((long)(phase1Size + phase2Size), (long)fcOrig.size());
            ((FileChannel)Mockito.verify((Object)fc, (VerificationMode)Mockito.times((int)((int)Math.ceil((double)phase2Size / 1024.0))))).write((ByteBuffer)Matchers.any(ByteBuffer.class));
        }
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Integer[]{160, 864, 1024, 1024, 1024, 1024, 1024, 1024, 992}), writeSizes);
    }

    @Test
    public void testWriteFileChannel() throws IOException {
        int pageSize = 1024;
        File file = this.folder.newFile();
        try (FileChannel fcOrig = FileChannel.open(file.toPath(), StandardOpenOption.WRITE);){
            FileChannel fc = (FileChannel)Mockito.spy((Object)fcOrig);
            ByteBuf bb = Unpooled.buffer();
            int numPhase1Uuids = 10;
            for (int i = 0; i < 10; ++i) {
                bb.writeBytes(Uuids.newUuidByteBuf());
            }
            Assert.assertTrue((bb.readableBytes() < 1024 ? 1 : 0) != 0);
            Assert.assertEquals((long)160L, (long)bb.readableBytes());
            try (ReadableByteChannel rbc = Channels.newChannel((InputStream)new ByteBufInputStream(bb));){
                ByteBufs.write((FileChannel)fc, (long)fc.position(), (long)bb.readableBytes(), (ReadableByteChannel)rbc);
            }
            Assert.assertEquals((long)160L, (long)fcOrig.size());
            ((FileChannel)Mockito.verify((Object)fc, (VerificationMode)Mockito.times((int)1))).transferFrom((ReadableByteChannel)Matchers.any(ReadableByteChannel.class), Mockito.anyLong(), Mockito.anyLong());
            Assert.assertEquals((long)0L, (long)fcOrig.position());
        }
        long phase1Size = file.length();
        try (FileChannel fcOrig = FileChannel.open(file.toPath(), StandardOpenOption.WRITE);){
            FileChannel fc = (FileChannel)Mockito.spy((Object)fcOrig);
            ByteBuf bb = Unpooled.buffer();
            int numPhase2Uuids = 500;
            for (int i = 0; i < 500; ++i) {
                bb.writeBytes(Uuids.newUuidByteBuf());
            }
            long phase2Size = bb.readableBytes();
            Assert.assertTrue((phase2Size > 3072L ? 1 : 0) != 0);
            Assert.assertEquals((long)8000L, (long)phase2Size);
            try (ReadableByteChannel rbc = Channels.newChannel((InputStream)new ByteBufInputStream(bb));){
                ByteBufs.write((FileChannel)fc, (long)fcOrig.size(), (long)bb.readableBytes(), (ReadableByteChannel)rbc);
            }
            Assert.assertEquals((long)(phase1Size + phase2Size), (long)fcOrig.size());
            ((FileChannel)Mockito.verify((Object)fc, (VerificationMode)Mockito.times((int)1))).transferFrom((ReadableByteChannel)Matchers.any(ReadableByteChannel.class), Mockito.anyLong(), Mockito.anyLong());
            Assert.assertEquals((long)0L, (long)fcOrig.position());
        }
    }
}

